/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimweb.push;

import eu.miltema.slimweb.ComponentsReader;
import eu.miltema.slimweb.annot.SessionNotRequired;
import eu.miltema.slimweb.common.SlimwebUtil;
import eu.miltema.slimweb.push.PushHandleImpl;
import eu.miltema.slimweb.push.ServerPush;
import eu.miltema.slimweb.push.WebsocketConfigurator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/push/{__component}", configurator=WebsocketConfigurator.class)
public class ServerPushEndpoint {
    private static final Logger log = LoggerFactory.getLogger(ServerPushEndpoint.class);
    private Map<String, Class<?>> mapComponents;

    @OnOpen
    public void onOpen(Session session, @PathParam(value="__component") String componentName, EndpointConfig config) {
        try {
            if (this.mapComponents == null) {
                this.mapComponents = new ComponentsReader(s -> log.info(s)).getComponentsAsStream().collect(Collectors.toMap(c -> SlimwebUtil.hyphenate(c.getSimpleName()), c -> c));
            }
            Map uprops = session.getUserProperties();
            HttpSession httpSession = (HttpSession)uprops.get("__httpSession");
            Map originalParams = (Map)uprops.get("__parameters");
            Map<String, String> params = originalParams.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("__")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((List)e.getValue()).stream().collect(Collectors.joining(","))));
            PushHandleImpl ph = new PushHandleImpl(httpSession, session);
            ph.componentName = componentName;
            ph.componentClass = Optional.ofNullable(this.mapComponents.get(componentName)).orElseThrow(() -> new Exception("Cannot map " + componentName + " to any @Component"));
            if (httpSession == null && !ph.componentClass.isAnnotationPresent(SessionNotRequired.class)) {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "Missing session"));
                return;
            }
            uprops.put("__handle", ph);
            ServerPush component = ph.componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            log.info("Request /push/" + componentName);
            component.pushStarted(ph, params);
        }
        catch (Exception e2) {
            log.error("", (Throwable)e2);
        }
    }

    @OnMessage
    public void onPong(Session session, PongMessage pongMsg) {
    }

    @OnMessage
    public String onMessage(String json, boolean isFinal, Session session) {
        if (!isFinal) {
            throw new RuntimeException("Partial messages not supported");
        }
        return null;
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        try {
            PushHandleImpl ph = (PushHandleImpl)session.getUserProperties().get("__handle");
            if (ph == null) {
                return;
            }
            log.info("Terminating /push/" + ph.componentName);
            if (ph.componentName != null) {
                Class<?> componentClass = this.mapComponents.get(ph.componentName);
                ServerPush component = (ServerPush)componentClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                component.pushTerminated(ph);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }

    @OnError
    public void onError(Session session, Throwable thr) {
    }
}

