/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimweb.view;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TemplateResolver {
    private Map<String, Function<String, String>> replacers = new HashMap<String, Function<String, String>>();

    TemplateResolver() {
    }

    String replace(String template, Map<String, String> replaceValues) {
        Pattern pattern = Pattern.compile("(\\{-)([^-]+)(-\\})");
        Matcher m = pattern.matcher(template);
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            String[] idsplit;
            Function<String, String> replacer;
            String id;
            Object replacement;
            if (m.start() > pos) {
                sb.append(template.substring(pos, m.start()));
            }
            if ((replacement = replaceValues.get(id = m.group(2))) == null && (replacer = this.replacers.get((idsplit = id.split(":"))[0] + ":")) != null) {
                replacement = replacer.apply(idsplit[1]);
            }
            if (replacement == null) {
                replacement = "!!!" + id + "!!!";
            }
            sb.append((String)replacement);
            pos = m.end();
        }
        int len = template.length();
        if (pos < len) {
            sb.append(template.substring(pos));
        }
        return sb.toString();
    }

    TemplateResolver customReplacer(String prefix, Function<String, String> replacer) {
        this.replacers.put(prefix, replacer);
        return this;
    }
}

