/*
 * Decompiled with CFR 0.152.
 */
package eu.miltema.slimweb.view;

import eu.miltema.cpscan.FileScanner;
import eu.miltema.slimweb.common.HttpAccessor;
import eu.miltema.slimweb.view.TemplateResolver;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(urlPatterns={"/view/*"})
public class ViewServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ViewServlet.class);
    private Map<String, Map<String, String>> localeLabels;
    private Map<String, Map<String, String>> localetemplateFiles;

    public void init() throws ServletException {
        try {
            this.initLocaleLabels();
            this.initLocaleTemplateFiles();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void initLocaleLabels() throws Exception {
        String LBLFILE_PATTERN = "(.*[/|\\\\])?([^/|\\\\]+)(\\.)lbl";
        log.info("Looking for label files");
        this.localeLabels = new FileScanner(s -> log.info(s), filename -> filename.endsWith(".lbl")).scan(new String[]{"labels"}).collect(Collectors.toMap(t -> t.path.replaceAll("(.*[/|\\\\])?([^/|\\\\]+)(\\.)lbl", "$2"), t -> this.getLabelsMap(t.content)));
    }

    private Map<String, String> getLabelsMap(String labelFile) {
        return labelFile.lines().filter(Predicate.not(String::isBlank)).map(line -> line.split("=")).collect(Collectors.toMap(ls -> ls[0].trim(), ls -> ls[1].trim()));
    }

    private void initLocaleTemplateFiles() throws Exception {
        String TPTFILE_PATTERN = "(.*[/|\\\\])?([^/|\\\\]+)(\\.)(html|htm|js)";
        log.info("Looking for template files");
        Map<String, String> templateFiles = new FileScanner(s -> log.info(s), filename -> filename.endsWith(".html") || filename.endsWith(".htm") || filename.endsWith(".js")).scan(new String[]{"templates"}).collect(Collectors.toMap(t -> t.path.replaceAll("(.*[/|\\\\])?([^/|\\\\]+)(\\.)(html|htm|js)", "$2$3$4"), t -> t.content));
        this.localetemplateFiles = this.localeLabels.entrySet().stream().collect(Collectors.toMap(locale -> (String)locale.getKey(), locale -> this.resolvedTemplates((Map)locale.getValue(), templateFiles)));
    }

    private Map<String, String> resolvedTemplates(Map<String, String> labels, Map<String, String> templateFiles) {
        String TPTFILE_PATTERN = "(.+)(\\.)(html|htm|js)";
        TemplateResolver resolver = new TemplateResolver();
        resolver.customReplacer("file:", filename -> resolver.replace((String)((Object)templateFiles.getOrDefault(filename, "!!!file:" + filename + "!!!")), labels));
        return templateFiles.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).replaceAll("(.+)(\\.)(html|htm|js)", "$1"), e -> resolver.replace((String)e.getValue(), labels)));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String templateName = req.getPathInfo();
        String lang = new ViewHtAccessor().init(req).getLanguage();
        Map localeTemplates = Optional.ofNullable(this.localetemplateFiles.get(lang)).orElseGet(() -> Optional.ofNullable(this.localetemplateFiles.get("en")).orElseGet(() -> this.localetemplateFiles.values().iterator().next()));
        String template = (String)localeTemplates.get(templateName == null || templateName.length() == 1 ? null : templateName.substring(1));
        resp.getWriter().print(template);
    }

    private class ViewHtAccessor
    extends HttpAccessor {
        private ViewHtAccessor() {
        }

        @Override
        public String getParametersAsJson() {
            return null;
        }

        @Override
        public String getParameter(String parameterName) {
            return null;
        }
    }
}

