/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerClient {
    private static final Logger log = LoggerFactory.getLogger(BrokerClient.class);
    private static final HttpClient client = HttpClientBuilder.create().build();

    public List<String> listSubscriptions(URL baseUrl, String email) throws Exception {
        String url = baseUrl + "/subscriptions?email=" + URLEncoder.encode(email, StandardCharsets.UTF_8.name());
        log.debug("Performing HTTP GET for subscriptions: " + url);
        HttpGet request = new HttpGet(url);
        request.addHeader("accept", "application/json");
        HttpResponse response = client.execute((HttpUriRequest)request);
        String json = IOUtils.toString((InputStream)response.getEntity().getContent());
        log.debug("Found subscriptions: " + json);
        JsonArray array = JsonParser.parseString((String)json).getAsJsonArray();
        log.info(String.format("Found %d subscription(s)", array.size()));
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < array.size(); ++i) {
            JsonObject object = array.get(i).getAsJsonObject();
            String suscrId = object.get("subscriptionId").getAsString();
            String topic = object.get("topic").getAsString();
            String ds = this.extractDsName(object.get("conditionsAsList").getAsJsonArray());
            log.info(String.format(" - %s (TOPIC: %s, Datasource: %s)", suscrId, topic, ds));
            res.add(suscrId);
        }
        return res;
    }

    public void downloadEvents(URL baseUrl, String subscrId, File outputDir, boolean gzip) throws Exception {
        block37: {
            String fp = String.format(gzip ? "%s/%s.json.gz" : "%s/%s.json", outputDir.getAbsolutePath(), subscrId);
            log.info("Saving file " + fp + ": ");
            if (gzip) {
                try (FileOutputStream fos = new FileOutputStream(fp);
                     OutputStreamWriter w = new OutputStreamWriter((OutputStream)new GZIPOutputStream(fos), "UTF-8");){
                    this.writeEvents(baseUrl, subscrId, w);
                    break block37;
                }
            }
            try (FileWriter fw = new FileWriter(fp);){
                this.writeEvents(baseUrl, subscrId, fw);
            }
        }
    }

    public void downloadEvents(URL baseUrl, String subscrId, OutputStream outputStream) throws Exception {
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
            this.writeEvents(baseUrl, subscrId, writer);
        }
    }

    private void writeEvents(URL baseUrl, String subscrId, Writer file) throws Exception {
        String url = baseUrl + "/scroll/notifications/bySubscriptionId/" + URLEncoder.encode(subscrId, StandardCharsets.UTF_8.name());
        boolean notCompleted = false;
        boolean first = true;
        file.append("[\n");
        do {
            log.debug("Performing HTTP GET for notifications: " + url);
            HttpGet request = new HttpGet(url);
            request.addHeader("accept", "application/json");
            HttpResponse response = client.execute((HttpUriRequest)request);
            String json = IOUtils.toString((InputStream)response.getEntity().getContent());
            JsonObject data = JsonParser.parseString((String)json).getAsJsonObject();
            JsonArray values = data.get("values").getAsJsonArray();
            for (int i = 0; i < values.size(); ++i) {
                if (first) {
                    first = false;
                } else {
                    file.append(",\n");
                }
                file.append(values.get(i).getAsJsonObject().toString());
            }
            boolean bl = notCompleted = !data.get("completed").getAsBoolean();
            if (!notCompleted) continue;
            url = baseUrl + "/scroll/notifications/" + data.get("id").getAsString();
        } while (notCompleted);
        file.append("\n]\n");
    }

    private String extractDsName(JsonArray conds) {
        try {
            for (int i = 0; i < conds.size(); ++i) {
                JsonObject object = conds.get(i).getAsJsonObject();
                if (!object.get("field").getAsString().equals("targetDatasourceName")) continue;
                return object.get("listParams").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage());
        }
        return "";
    }
}

