/*
 * Decompiled with CFR 0.152.
 */
package csv;

import csv.MimeTypeInfo;
import csv.TableReader;
import csv.impl.AbstractStreamTableReader;
import csv.impl.AbstractStreamTableWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;

public class CSVFactory {
    private Map<String, Class<? extends AbstractStreamTableReader>> readers;
    private Map<String, Class<? extends AbstractStreamTableWriter>> writers;
    private static CSVFactory factory = null;

    public static CSVFactory getFactory() {
        if (factory == null) {
            factory = new CSVFactory();
        }
        return factory;
    }

    protected CSVFactory() {
        this.init();
    }

    protected void init() {
        this.initReaderMap();
        this.initWriterMap();
        this.register(MimeTypeInfo.CSV_INFO);
        this.register(MimeTypeInfo.EXCEL_INFO);
        this.register(MimeTypeInfo.XML_INFO);
    }

    protected void initReaderMap() {
        if (this.readers != null) {
            return;
        }
        this.readers = new HashMap<String, Class<? extends AbstractStreamTableReader>>();
    }

    protected void initWriterMap() {
        if (this.writers != null) {
            return;
        }
        this.writers = new HashMap<String, Class<? extends AbstractStreamTableWriter>>();
    }

    public void register(MimeTypeInfo mimeTypeInfo) {
        String[] types = mimeTypeInfo.getMimeTypes();
        Class<? extends AbstractStreamTableReader> reader = mimeTypeInfo.getReaderClass();
        Class<? extends AbstractStreamTableWriter> writer = mimeTypeInfo.getWriterClass();
        for (int i = 0; i < types.length; ++i) {
            if (reader != null) {
                this.readers.put(types[i], reader);
            }
            if (writer == null) continue;
            this.writers.put(types[i], writer);
        }
    }

    public TableReader getReader(String file) throws IOException {
        return this.getReader(new File(file));
    }

    public TableReader getReader(File file) throws IOException {
        String mimeType = this.getMimeType(file);
        if (mimeType == null) {
            throw new IllegalArgumentException("No MIME type found: " + file.getAbsolutePath());
        }
        AbstractStreamTableReader reader = this.getMimeTypeReader(mimeType);
        reader.setInputStream(new FileInputStream(file));
        return reader;
    }

    public AbstractStreamTableReader getMimeTypeReader(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("NULL MIME type");
        }
        Class<? extends AbstractStreamTableReader> readerClass = this.readers.get(mimeType);
        if (readerClass == null) {
            throw new IllegalArgumentException("Cannot find reader class for: " + mimeType);
        }
        try {
            AbstractStreamTableReader reader = readerClass.newInstance();
            return reader;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create reader instance: ", e);
        }
    }

    public AbstractStreamTableWriter getWriter(String file) throws IOException {
        return this.getWriter(new File(file));
    }

    public AbstractStreamTableWriter getWriter(File file) throws IOException {
        String mimeType = this.getMimeType(file);
        if (mimeType == null) {
            throw new IllegalArgumentException("No MIME type found: " + file.getAbsolutePath());
        }
        AbstractStreamTableWriter writer = this.getMimeTypeWriter(mimeType);
        writer.setOutputStream(new FileOutputStream(file));
        return writer;
    }

    public AbstractStreamTableWriter getMimeTypeWriter(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("NULL MIME type");
        }
        Class<? extends AbstractStreamTableWriter> writerClass = this.writers.get(mimeType);
        if (writerClass == null) {
            throw new IllegalArgumentException("Cannot find writer class for: " + mimeType);
        }
        try {
            AbstractStreamTableWriter writer = writerClass.newInstance();
            return writer;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create writer instance: ", e);
        }
    }

    public String getMimeType(File file) {
        return new MimetypesFileTypeMap().getContentType(file);
    }
}

