/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.CommentCallback;
import csv.TableReader;

public abstract class AbstractColumnFilter
implements TableReader {
    private TableReader reader;
    private int rowIndex = 0;

    public AbstractColumnFilter(TableReader reader) {
        this.reader = reader;
    }

    protected TableReader getReader() {
        return this.reader;
    }

    @Override
    public void close() {
        this.getReader().close();
    }

    @Override
    public Object get(String name, Object[] row) {
        return this.getReader().get(name, row);
    }

    @Override
    public int getColumnIndex(String name) {
        return this.getFilteredIndex(this.getReader().getColumnIndex(name));
    }

    @Override
    public Object[] getHeaderRow() {
        return this.filter(this.getReader().getHeaderRow());
    }

    @Override
    public int getMinimumColumnCount() {
        return this.getReader().getMinimumColumnCount();
    }

    @Override
    public boolean hasHeaderRow() {
        return this.getReader().hasHeaderRow();
    }

    @Override
    public void open() {
        this.getReader().open();
        this.rowIndex = 0;
    }

    @Override
    public void registerCommentCallBack(CommentCallback callback) {
        this.getReader().registerCommentCallBack(callback);
    }

    @Override
    public void reset() {
        this.getReader().reset();
        this.rowIndex = 0;
    }

    @Override
    public void setHasHeaderRow(boolean hasHeaderRow) {
        this.getReader().setHasHeaderRow(hasHeaderRow);
    }

    @Override
    public void setMinimumColumnCount(int length) {
        this.getReader().setMinimumColumnCount(length);
    }

    @Override
    public void unregisterCommentCallBack(CommentCallback callback) {
        this.getReader().unregisterCommentCallBack(callback);
    }

    @Override
    public boolean hasNext() {
        return this.getReader().hasNext();
    }

    protected int getRowIndex() {
        return this.rowIndex;
    }

    @Override
    public Object[] next() {
        ++this.rowIndex;
        return this.filter((Object[])this.getReader().next());
    }

    protected Object[] filter(Object[] row) {
        if (row == null) {
            return null;
        }
        Object[] rc = new Object[row.length];
        for (int i = 0; i < rc.length; ++i) {
            int newIndex = this.getFilteredIndex(i);
            if (newIndex < 0 || newIndex >= rc.length) continue;
            rc[newIndex] = row[i];
        }
        return rc;
    }

    protected abstract int getFilteredIndex(int var1);

    @Override
    public void remove() {
        this.getReader().remove();
    }
}

