/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.impl.AbstractTableReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public abstract class AbstractStreamTableReader
extends AbstractTableReader {
    private InputStream inputStream;
    private BufferedReader reader;
    private CharsetDecoder charsetDecoder = Charset.defaultCharset().newDecoder();

    public AbstractStreamTableReader() {
    }

    public AbstractStreamTableReader(InputStream in) {
        this.setInputStream(in);
    }

    public AbstractStreamTableReader(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public AbstractStreamTableReader(String file) throws FileNotFoundException {
        this(new File(file));
    }

    public void setInputStream(InputStream in) {
        if (this.inputStream != null) {
            throw new IllegalStateException("InputStream already set");
        }
        this.inputStream = in;
        this.open();
    }

    protected BufferedReader getReader() {
        if (this.reader == null) {
            this.reader = this.createReader();
        }
        return this.reader;
    }

    protected BufferedReader createReader() {
        return new BufferedReader(this.createInputStreamReader(this.getInputStream()));
    }

    protected InputStreamReader createInputStreamReader(InputStream stream) {
        return new InputStreamReader(stream, this.getCharsetDecoder());
    }

    public CharsetDecoder getCharsetDecoder() {
        return this.charsetDecoder;
    }

    public void setCharsetDecoder(CharsetDecoder charsetDecoder) {
        this.charsetDecoder = charsetDecoder;
    }

    public void setCharset(Charset charset) {
        this.setCharsetDecoder(charset.newDecoder());
    }

    public void setCharset(String charset) {
        this.setCharset(Charset.forName(charset));
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void reset() {
        try {
            if (this.getInputStream() != null) {
                this.getInputStream().reset();
            }
            if (this.reader != null) {
                this.reader.reset();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.toString(), e);
        }
        super.reset();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation not supported for CSV streams");
    }

    @Override
    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
        super.close();
    }
}

