/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.TableWriter;
import csv.TypeConversionHandler;
import csv.impl.type.BooleanConversionHandler;
import csv.impl.type.ByteConversionHandler;
import csv.impl.type.CharConversionHandler;
import csv.impl.type.DateConversionHandler;
import csv.impl.type.DoubleConversionHandler;
import csv.impl.type.FloatConversionHandler;
import csv.impl.type.IntegerConversionHandler;
import csv.impl.type.LongConversionHandler;
import csv.impl.type.ShortConversionHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractTableWriter
implements TableWriter {
    private int rowCount;
    private Map<String, TypeConversionHandler> typeConversionHandlers = new HashMap<String, TypeConversionHandler>();

    protected void init() {
        this.rowCount = 0;
        this.registerTypeConversionHandler(BooleanConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(ByteConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(CharConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(DoubleConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(FloatConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(IntegerConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(LongConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(ShortConversionHandler.INSTANCE);
        this.registerTypeConversionHandler(DateConversionHandler.INSTANCE);
    }

    @Override
    public void printComment(String comment) throws IOException {
    }

    @Override
    public void printComment(String comment, int row, int column) throws IOException {
    }

    @Override
    public void close() {
    }

    public int getRowCount() {
        return this.rowCount;
    }

    protected int incrementRowCount() {
        ++this.rowCount;
        return this.rowCount;
    }

    public void registerTypeConversionHandler(TypeConversionHandler handler) {
        for (String type : handler.getTypes()) {
            this.typeConversionHandlers.put(type, handler);
        }
    }

    public void unregisterTypeConversionHandler(TypeConversionHandler handler) {
        for (String type : handler.getTypes()) {
            this.typeConversionHandlers.remove(type);
        }
    }

    protected TypeConversionHandler getTypeConversionHandler(String type) {
        return this.typeConversionHandlers.get(type);
    }

    protected String convert(Object value) {
        if (value == null) {
            return null;
        }
        return this.convert(value.getClass().getName(), value);
    }

    protected String convert(String type, Object value) {
        if (value == null) {
            return null;
        }
        TypeConversionHandler handler = this.getTypeConversionHandler(type);
        if (handler != null) {
            return handler.toString(value);
        }
        return value.toString();
    }
}

