/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.impl.AbstractStreamTableReader;
import csv.util.CSVUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;

public class CSVReader
extends AbstractStreamTableReader {
    private static final int MODE_PRE_DELIM = 0;
    private static final int MODE_DATA_DELIM = 1;
    private static final int MODE_DATA_NODELIM = 2;
    private static final int MODE_POST_DELIM = 3;
    private static final int MODE_COMMENT = 4;
    private String columnDelimiter = "\"";
    private char columnSeparator = (char)59;
    private Iterator<Object[]> rowIterator;
    private boolean ignoreComments = true;
    private char[] commentChars = new char[]{'#', ';', '!'};
    private boolean ignoreEmptyLines = true;
    private BufferedReader argReader;

    public CSVReader() {
    }

    public CSVReader(InputStream in) {
        super(in);
    }

    @Deprecated
    public CSVReader(Reader in) {
        this.argReader = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
    }

    public CSVReader(File file) throws FileNotFoundException {
        super(file);
    }

    public CSVReader(String file) throws FileNotFoundException {
        super(file);
    }

    @Override
    public void close() {
        if (this.argReader != null) {
            try {
                this.argReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        super.close();
    }

    @Override
    protected BufferedReader getReader() {
        if (this.argReader != null) {
            return this.argReader;
        }
        return super.getReader();
    }

    @Override
    public void reset() {
        if (this.argReader != null) {
            try {
                this.argReader.reset();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        super.reset();
    }

    public void setColumnDelimiter(String s) {
        this.columnDelimiter = s;
    }

    public String getColumnDelimiter() {
        return this.columnDelimiter;
    }

    public void setColumnSeparator(char s) {
        this.columnSeparator = s;
    }

    public char getColumnSeparator() {
        return this.columnSeparator;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public String getCommentChars() {
        return new String(this.commentChars);
    }

    public void setCommentChars(String commentChars) {
        this.commentChars = commentChars.toCharArray();
    }

    public boolean isIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    public void setIgnoreEmptyLines(boolean ignoreEmptyLines) {
        this.ignoreEmptyLines = ignoreEmptyLines;
    }

    private Object[] convertToColumnArray(StringBuffer s) {
        Object[] rc = null;
        ArrayList<String> columns = new ArrayList<String>();
        int len = s.length();
        String curCol = "";
        String comment = "";
        int mode = 0;
        block7: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (mode) {
                case 0: {
                    if (this.isSeparator(c)) {
                        columns.add(curCol);
                        curCol = "";
                        continue block7;
                    }
                    if (this.isDelimiter(c)) {
                        mode = 1;
                        continue block7;
                    }
                    if (this.isSpace(c)) continue block7;
                    if (this.isCommentChar(c) && i == 0) {
                        mode = 4;
                        comment = "";
                        continue block7;
                    }
                    if (this.isLineSeparator(c) && i == 0) {
                        if (this.isIgnoreEmptyLines()) continue block7;
                        s.delete(0, i + 1);
                        return new Object[Math.max(0, this.getMinimumColumnCount())];
                    }
                    if (this.isLineSeparator(c)) {
                        columns.add(null);
                        rc = this.convertArray(columns);
                        s.delete(0, i + 1);
                        return rc;
                    }
                    curCol = curCol + c;
                    mode = 2;
                    continue block7;
                }
                case 3: {
                    if (this.isSeparator(c)) {
                        columns.add(curCol);
                        curCol = "";
                        mode = 0;
                        continue block7;
                    }
                    if (!this.isLineSeparator(c)) continue block7;
                    columns.add(curCol);
                    rc = this.convertArray(columns);
                    s.delete(0, i + 1);
                    return rc;
                }
                case 1: {
                    if (this.isDelimiter(c)) {
                        if (i < len - 1 && c == s.charAt(i + 1)) {
                            curCol = curCol + c;
                            ++i;
                            continue block7;
                        }
                        mode = 3;
                        continue block7;
                    }
                    curCol = curCol + c;
                    continue block7;
                }
                case 2: {
                    if (this.isSeparator(c)) {
                        columns.add(curCol.trim());
                        curCol = "";
                        mode = 0;
                        continue block7;
                    }
                    if (this.isLineSeparator(c)) {
                        columns.add(curCol.trim());
                        rc = this.convertArray(columns);
                        s.delete(0, i + 1);
                        return rc;
                    }
                    curCol = curCol + c;
                    continue block7;
                }
                case 4: {
                    if (this.isLineSeparator(c)) {
                        mode = 0;
                        this.notifyComment(comment.trim(), this.getLineCount(), -1);
                        continue block7;
                    }
                    comment = comment + c;
                }
            }
        }
        if (mode == 1) {
            return null;
        }
        columns.add(curCol);
        rc = this.convertArray(columns);
        s.delete(0, s.length());
        return rc;
    }

    protected boolean isCommentChar(char c) {
        for (int i = 0; i < this.commentChars.length; ++i) {
            if (c != this.commentChars[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean isSeparator(char c) {
        return this.columnSeparator == c;
    }

    protected boolean isSpace(char c) {
        return c == ' ';
    }

    protected boolean isDelimiter(char c) {
        if (this.columnDelimiter != null) {
            return this.columnDelimiter.indexOf(c) >= 0;
        }
        return false;
    }

    protected boolean isLineSeparator(char c) {
        return c == '\n';
    }

    @Override
    public boolean hasNext() {
        this.readHeaderRow();
        return this.getRowIterator().hasNext();
    }

    @Override
    public Object[] next() {
        this.readHeaderRow();
        return this.getRowIterator().next();
    }

    @Override
    protected void readHeaderRow() {
        if (this.isHeaderRowRead() || !this.hasHeaderRow()) {
            return;
        }
        if (this.getRowIterator().hasNext()) {
            this.setHeaderRow(CSVUtils.convertArray(this.getRowIterator().next(), this.getMinimumColumnCount()));
        }
    }

    private Iterator<Object[]> getRowIterator() {
        if (this.rowIterator == null) {
            this.rowIterator = new CSVRowIterator();
        }
        return this.rowIterator;
    }

    protected static void debug(int idx, String[] o) {
        System.out.print(idx + ":");
        for (int i = 0; i < o.length; ++i) {
            System.out.print(" [" + o[i] + "]");
        }
        System.out.println();
    }

    private class CSVRowIterator
    implements Iterator<Object[]> {
        private ArrayList<String> lineBuffer = new ArrayList();

        @Override
        public boolean hasNext() {
            return this.internalHasNext();
        }

        private boolean internalHasNext() {
            if (this.lineBuffer.size() > 0) {
                return true;
            }
            try {
                boolean doRead = true;
                while (doRead) {
                    String s;
                    doRead = false;
                    if (!CSVReader.this.getReader().ready() || (s = CSVReader.this.getReader().readLine()) == null) continue;
                    CSVReader.this.incrementLineCount();
                    this.lineBuffer.add(s);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.lineBuffer.size() > 0;
        }

        @Override
        public Object[] next() {
            Object[] o = null;
            StringBuffer s = new StringBuffer();
            while (o == null) {
                if (!this.internalHasNext()) {
                    throw new IllegalStateException("No more rows");
                }
                String line = this.lineBuffer.remove(0);
                s.append(line);
                s.append('\n');
                o = CSVReader.this.convertToColumnArray(s);
            }
            CSVReader.this.incrementRowCount();
            return o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }
    }
}

