/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.impl.AbstractStreamTableReader;
import csv.util.CSVUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelReader
extends AbstractStreamTableReader {
    private Workbook workbook;
    private FormulaEvaluator formulaEvaluator = null;
    private boolean evaluateFormulas = true;
    private Sheet sheet;
    private Row currentRow;
    private Row lastDeliveredRow;
    private int firstRow;
    private int lastRow;
    private int rowNum;
    private boolean skipBlankRows = true;

    public ExcelReader() {
    }

    public ExcelReader(File file) throws FileNotFoundException {
        super(file);
    }

    public ExcelReader(InputStream in) {
        super(in);
    }

    public ExcelReader(Workbook workbook) {
        this.workbook = workbook;
    }

    public ExcelReader(String file) throws FileNotFoundException {
        super(file);
    }

    @Override
    public void open() {
        super.open();
        try {
            this.workbook = WorkbookFactory.create((InputStream)this.getInputStream());
            this.selectSheet(0);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create Excel workbook", e);
        }
    }

    public Workbook getWorkbook() {
        if (this.workbook == null) {
            this.open();
        }
        return this.workbook;
    }

    public boolean isSkipBlankRows() {
        return this.skipBlankRows;
    }

    public void setSkipBlankRows(boolean skipBlankRows) {
        this.skipBlankRows = skipBlankRows;
    }

    public int computeMaxColumnCount() {
        short maxColumnCount = 0;
        Iterator i = this.sheet.rowIterator();
        while (i.hasNext()) {
            short length = ((Row)i.next()).getLastCellNum();
            if (length <= maxColumnCount) continue;
            maxColumnCount = length;
        }
        return maxColumnCount;
    }

    public Sheet selectSheet(String name) {
        return this.selectSheet(this.workbook.getSheet(name));
    }

    public Sheet selectSheet(Sheet sheet) {
        if (this.sheet != sheet) {
            this.sheet = sheet;
            this.rowNum = this.firstRow = sheet.getFirstRowNum();
            this.lastRow = sheet.getLastRowNum();
            this.currentRow = null;
        }
        return this.sheet;
    }

    public Sheet selectSheet(int index) {
        return this.selectSheet(this.workbook.getSheetAt(index));
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public Row getLastExcelRow() {
        return this.lastDeliveredRow;
    }

    @Override
    public void reset() {
        super.reset();
        this.rowNum = this.firstRow;
        this.currentRow = null;
    }

    @Override
    public boolean hasNext() {
        if (this.currentRow == null) {
            this.retrieveNextRow();
        }
        return this.currentRow != null;
    }

    @Override
    public Object[] next() {
        if (this.hasNext()) {
            Object[] row = this.getValues(this.currentRow);
            this.lastDeliveredRow = this.currentRow;
            this.currentRow = null;
            this.incrementLineCount();
            this.incrementRowCount();
            return row;
        }
        throw new IllegalStateException("No more rows");
    }

    public Object[] getValues(int rowNum) {
        Row row = this.getSheet().getRow(rowNum);
        return this.getValues(row);
    }

    public Object[] getValues(Row row) {
        if (row == null) {
            return null;
        }
        ArrayList<Object> columns = new ArrayList<Object>();
        int colCount = row.getLastCellNum();
        for (int col = 0; col < colCount; ++col) {
            Cell cell = row.getCell(col);
            columns.add(this.getValue(cell));
        }
        return CSVUtils.convertList(columns, this.getMinimumColumnCount());
    }

    public Object getValue(int rownum, int cellNum) {
        Row row = this.getSheet().getRow(this.rowNum);
        return this.getValue(row, cellNum);
    }

    public Object getValue(Row row, int cellNum) {
        if (row == null) {
            return null;
        }
        Cell cell = row.getCell(cellNum);
        return this.getValue(cell);
    }

    public Object getValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        int cellType = cell.getCellType();
        if (cellType == 2 && !this.isEvaluateFormulas()) {
            cellType = cell.getCachedFormulaResultType();
        }
        switch (cellType) {
            case 1: {
                return cell.getStringCellValue();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case 3: {
                return null;
            }
            case 4: {
                return cell.getBooleanCellValue();
            }
            case 2: {
                return this.evaluateCellValue(cell);
            }
            case 5: {
                return cell.getErrorCellValue();
            }
        }
        return null;
    }

    public Object evaluateCellValue(Cell cell) {
        FormulaEvaluator evaluator = this.getFormulaEvaluator();
        CellValue value = evaluator.evaluate(cell);
        switch (value.getCellType()) {
            case 1: {
                return value.getStringValue();
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return DateUtil.getJavaDate((double)value.getNumberValue());
                }
                return value.getNumberValue();
            }
            case 3: {
                return null;
            }
            case 4: {
                return value.getBooleanValue();
            }
            case 5: {
                return value.getErrorValue();
            }
        }
        System.out.println("type=" + cell.getCellType());
        return cell.getCellFormula();
    }

    public FormulaEvaluator getFormulaEvaluator() {
        if (this.formulaEvaluator == null) {
            this.formulaEvaluator = this.getWorkbook().getCreationHelper().createFormulaEvaluator();
        }
        return this.formulaEvaluator;
    }

    public boolean isEvaluateFormulas() {
        return this.evaluateFormulas;
    }

    public void setEvaluateFormulas(boolean evaluateFormulas) {
        this.evaluateFormulas = evaluateFormulas;
    }

    @Override
    protected void readHeaderRow() {
        if (this.hasNext()) {
            this.setHeaderRow(CSVUtils.convertArray(this.next(), this.getMinimumColumnCount()));
        }
    }

    protected void retrieveNextRow() {
        while (this.rowNum <= this.lastRow) {
            this.currentRow = this.getOrCreateRow(this.rowNum++);
            if (this.currentRow == null) continue;
            if (!this.isSkipBlankRows() || !this.rowHasOnlyBlankCells(this.currentRow)) break;
            this.currentRow = null;
        }
    }

    protected boolean rowHasOnlyBlankCells(Row row) {
        boolean blank = true;
        for (Cell cell : row) {
            if (cell.getCellType() == 3) continue;
            blank = false;
            break;
        }
        return blank;
    }

    protected Row getOrCreateRow(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (!this.isSkipBlankRows() && row == null) {
            row = this.sheet.createRow(rowNum);
        }
        return row;
    }
}

