/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.impl.AbstractStreamTableWriter;
import csv.impl.ExcelFormatter;
import csv.impl.ExcelListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelWriter
extends AbstractStreamTableWriter {
    private Workbook workbook;
    private Sheet sheet;
    private int rowNum;
    private int maxColumns;
    private Set<ExcelListener> excelListeners = new HashSet<ExcelListener>();
    private ExcelFormatter formatter;

    public ExcelWriter() {
    }

    public ExcelWriter(Workbook workbook) {
        this.workbook = workbook;
    }

    public ExcelWriter(OutputStream out) {
        this(null, out);
    }

    public ExcelWriter(Workbook workbook, OutputStream out) {
        super(out);
        this.workbook = workbook;
    }

    public ExcelWriter(File file) throws IOException {
        this(null, file);
    }

    public ExcelWriter(Workbook workbook, File file) throws IOException {
        super(file);
        this.workbook = workbook;
    }

    public ExcelWriter(String file) throws IOException {
        this(null, file);
    }

    public ExcelWriter(Workbook workbook, String file) throws IOException {
        super(file);
        this.workbook = workbook;
    }

    @Override
    public void printRow(Object[] columns) throws IOException {
        this.printRow(columns, this.rowNum);
        ++this.rowNum;
        this.incrementRowCount();
    }

    public void printRow(Object[] columns, int rowNum) throws IOException {
        Row row = this.getOrCreateRow(rowNum);
        for (int i = 0; i < columns.length; ++i) {
            this.setValue(row, i, columns[i]);
        }
    }

    @Override
    public void printComment(String comment, int row, int column) throws IOException {
    }

    public Cell getOrCreateCell(int row, int column) {
        Row r = this.getOrCreateRow(row);
        return this.getOrCreateCell(r, column);
    }

    public Cell getOrCreateCell(Row row, int column) {
        Cell cell = row.getCell(column);
        if (cell == null) {
            cell = row.createCell(column);
        }
        return cell;
    }

    public Row getOrCreateRow(int row) {
        Row r = this.getSheet().getRow(row);
        if (r == null) {
            r = this.getSheet().createRow(row);
            this.notifyExcelListeners(r);
        }
        return r;
    }

    public void setValue(int row, int column, Object value) {
        Row r = this.getOrCreateRow(row);
        this.setValue(r, column, value);
    }

    public void setValue(Row row, int column, Object value) {
        Cell cell = this.getOrCreateCell(row, column);
        this.setValue(cell, value);
    }

    public void setValue(Cell cell, Object value) {
        if (value != null) {
            if (value instanceof Date) {
                cell.setCellValue((Date)value);
            } else if (value instanceof Double) {
                cell.setCellValue(((Double)value).doubleValue());
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else {
                cell.setCellValue(value.toString());
            }
            if (cell.getColumnIndex() > this.maxColumns) {
                this.maxColumns = cell.getColumnIndex();
            }
        }
        this.setStyle(cell, value);
    }

    public Workbook getWorkbook() {
        if (this.workbook == null) {
            this.workbook = new HSSFWorkbook();
        }
        return this.workbook;
    }

    public Sheet getSheet() {
        if (this.sheet == null) {
            this.sheet = this.createSheet();
            this.selectSheet(this.sheet);
        }
        return this.sheet;
    }

    public void selectSheet(Sheet sheet) {
        sheet.setSelected(true);
        this.rowNum = 0;
        this.maxColumns = -1;
    }

    public Sheet selectSheet(int index) {
        this.sheet = this.getWorkbook().getSheetAt(index);
        if (this.sheet == null) {
            this.sheet = this.createSheet(index);
        }
        this.selectSheet(this.sheet);
        return this.sheet;
    }

    public Sheet createSheet() {
        return this.createSheet(-1);
    }

    public Sheet createSheet(int index) {
        return this.createSheet(index, "Sheet" + (this.getWorkbook().getNumberOfSheets() + 1));
    }

    public Sheet createSheet(int index, String name) {
        Sheet rc = this.getWorkbook().createSheet(name);
        if (index >= 0) {
            this.getWorkbook().setSheetOrder(name, index);
        }
        return rc;
    }

    @Override
    public void close() {
        try {
            if (this.formatter != null) {
                this.formatter.finalize(this, this.getSheet().getLastRowNum(), this.maxColumns);
            }
            this.getWorkbook().write(this.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.close();
    }

    public void registerExcelListener(ExcelListener l) {
        this.excelListeners.add(l);
    }

    public void unregisterExcelListener(ExcelListener l) {
        this.excelListeners.remove(l);
    }

    protected void notifyExcelListeners(Row row) {
        for (ExcelListener l : this.excelListeners) {
            l.rowCreated(this, row);
        }
    }

    public ExcelFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(ExcelFormatter formatter) {
        this.formatter = formatter;
    }

    protected void setStyle(Cell cell, Object value) {
        if (this.getFormatter() != null) {
            this.getFormatter().setStyle(this, cell, value);
        }
    }
}

