/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.TableReader;
import csv.impl.AbstractRowFilter;
import java.util.Arrays;

public class IndexRowFilter
extends AbstractRowFilter {
    private int[] validRowIndices;
    private int validIndex = 0;

    public IndexRowFilter(TableReader reader, int[] validRowIndices) {
        super(reader);
        this.validRowIndices = validRowIndices;
        Arrays.sort(this.validRowIndices);
    }

    @Override
    protected boolean isValidRow(Object[] row) {
        if (this.validIndex < this.validRowIndices.length && this.getRawRowIndex() == this.validRowIndices[this.validIndex]) {
            ++this.validIndex;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isMoreRowsExpected() {
        return this.validIndex < this.validRowIndices.length;
    }

    @Override
    public void open() {
        super.open();
        this.validIndex = 0;
    }

    @Override
    public void reset() {
        super.reset();
        this.validIndex = 0;
    }
}

