/*
 * Decompiled with CFR 0.152.
 */
package csv.impl;

import csv.impl.AbstractStreamTableReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReader
extends AbstractStreamTableReader {
    protected static final int END_OF_FILE_INDEX = -1;
    private ParserThread parserThread = null;
    private Object[] nextRow = null;
    private String rowTagName = "record";
    private String columnTagName = "column";
    private boolean useColumnNameTags = false;
    private String columnNameAttribute = "name";
    private String columnTypeAttribute = "type";

    public XmlReader() {
        this.setHasHeaderRow(true);
    }

    public XmlReader(InputStream in) {
        super(in);
        this.setHasHeaderRow(true);
    }

    public XmlReader(File file) throws FileNotFoundException {
        super(file);
        this.setHasHeaderRow(true);
    }

    public XmlReader(String file) throws FileNotFoundException {
        super(file);
        this.setHasHeaderRow(true);
    }

    @Override
    public void close() {
        if (this.parserThread != null) {
            this.deliverComments(-1);
        }
        super.close();
    }

    @Override
    public void reset() {
        if (this.parserThread != null) {
            this.parserThread.stopParsing();
            this.parserThread = null;
        }
        super.reset();
    }

    @Override
    public boolean hasNext() {
        if (this.nextRow == null) {
            this.readNextRow();
        }
        return this.nextRow != null;
    }

    @Override
    public Object[] next() {
        if (this.nextRow == null) {
            this.readNextRow();
        }
        if (this.nextRow == null) {
            throw new IllegalStateException("End of XML stream reached");
        }
        this.deliverComments();
        Object[] rc = this.nextRow;
        this.nextRow = null;
        this.incrementRowCount();
        return rc;
    }

    protected void readNextRow() {
        if (this.nextRow != null) {
            return;
        }
        if (this.parserThread == null) {
            this.initParser();
        }
        this.nextRow = this.parserThread.next();
    }

    @Override
    protected void readHeaderRow() {
        if (this.parserThread == null) {
            this.initParser();
        }
        if (this.isHeaderRowRead()) {
            return;
        }
        this.setHeaderRow(this.parserThread.getColumnNames());
    }

    protected void initParser() {
        if (this.parserThread == null) {
            this.parserThread = new ParserThread();
            this.parserThread.start();
        }
    }

    protected void deliverComments() {
        this.deliverComments(this.getRowCount());
    }

    protected void deliverComments(int rowIndex) {
        List<String> comments = this.parserThread.deliverComments(rowIndex);
        if (comments != null) {
            for (String comment : comments) {
                this.notifyComment(comment, rowIndex, 0);
            }
        }
    }

    public String getRowTagName() {
        return this.rowTagName;
    }

    public void setRowTagName(String rowTagName) {
        this.rowTagName = rowTagName;
    }

    public String getColumnTagName() {
        return this.columnTagName;
    }

    public void setColumnTagName(String columnTagName) {
        this.columnTagName = columnTagName;
    }

    public boolean isUseColumnNameTags() {
        return this.useColumnNameTags;
    }

    public void setUseColumnNameTags(boolean useColumnNameTags) {
        this.useColumnNameTags = useColumnNameTags;
    }

    public String getColumnNameAttribute() {
        return this.columnNameAttribute;
    }

    public void setColumnNameAttribute(String columnNameAttribute) {
        this.columnNameAttribute = columnNameAttribute;
    }

    public String getColumnTypeAttribute() {
        return this.columnTypeAttribute;
    }

    public void setColumnTypeAttribute(String columnTypeAttribute) {
        this.columnTypeAttribute = columnTypeAttribute;
    }

    private class XmlHandler
    extends DefaultHandler2 {
        private ParserThread thread = null;
        private boolean isRow = false;
        private boolean isCollectingChars = false;
        private StringBuffer charBuf = new StringBuffer();
        private String columnName = null;
        private String columnType = null;
        private List<String> columnNames;
        private Map<String, Object> columnValues;
        private int rowCount;

        public XmlHandler(ParserThread thread) {
            this.thread = thread;
        }

        @Override
        public void startDocument() throws SAXException {
            this.columnNames = new ArrayList<String>();
            this.columnValues = new HashMap<String, Object>();
            this.rowCount = 0;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.isRow) {
                this.columnName = this.getColumnName(qName, attributes);
                this.columnType = this.getColumnType(attributes);
                this.isCollectingChars = true;
                this.charBuf = new StringBuffer();
            } else if (qName.equals(XmlReader.this.getRowTagName())) {
                this.isRow = true;
                this.columnValues.clear();
            }
        }

        protected String getColumnName(String tagName, Attributes attr) {
            if (XmlReader.this.isUseColumnNameTags()) {
                return tagName;
            }
            return attr.getValue(XmlReader.this.getColumnNameAttribute());
        }

        protected String getColumnType(Attributes attr) {
            return attr.getValue(XmlReader.this.getColumnTypeAttribute());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.isCollectingChars) {
                this.charBuf.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.isCollectingChars) {
                this.isCollectingChars = false;
                this.addColumnValue(this.columnName, this.columnType, this.charBuf.toString());
            } else if (this.isRow) {
                this.isRow = false;
                this.thread.addObject(this.getValueArray());
                ++this.rowCount;
            }
        }

        protected Object[] getValueArray() {
            Object[] rc = new Object[this.columnNames.size()];
            for (int i = 0; i < rc.length; ++i) {
                rc[i] = this.columnValues.get(this.columnNames.get(i));
            }
            return rc;
        }

        protected void addColumnValue(String columnName, String columnType, String value) {
            Object v = null;
            if (!this.columnNames.contains(columnName)) {
                this.columnNames.add(columnName);
            }
            v = columnType == null && (value == null || value.length() == 0) ? null : XmlReader.this.convert(columnType, value);
            this.columnValues.put(columnName, v);
        }

        @Override
        public void endDocument() throws SAXException {
            this.thread.addObject(null);
        }

        public String[] getColumnNames() {
            String[] rc = new String[this.columnNames.size()];
            this.columnNames.toArray(rc);
            return rc;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            this.thread.registerComment(this.rowCount, new String(ch, start, length));
        }
    }

    private class ParserThread
    extends Thread {
        private SAXParser parser = null;
        private IllegalStateException parsingError = null;
        private List<Object[]> availableObjects = new ArrayList<Object[]>();
        private String[] columnNames = null;
        private boolean parsingStopped = false;
        private XmlHandler handler = null;
        private Map<Integer, List<String>> comments = new HashMap<Integer, List<String>>();

        @Override
        public void run() {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                this.parser = factory.newSAXParser();
                this.handler = new XmlHandler(this);
                this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this.handler);
                this.parser.parse(XmlReader.this.getInputStream(), (DefaultHandler)this.handler);
            }
            catch (Exception e) {
                this.parsingError = new IllegalStateException(e);
            }
        }

        public void stopParsing() {
        }

        public String[] getColumnNames() {
            if (this.columnNames == null) {
                this.next(false);
                this.columnNames = this.handler.getColumnNames();
            }
            return this.columnNames;
        }

        public IllegalStateException getParsingError() {
            return this.parsingError;
        }

        public List<String> deliverComments(int rowIndex) {
            if (rowIndex == -1) {
                ArrayList<String> rc = new ArrayList<String>();
                Set<Integer> keys = this.comments.keySet();
                for (Integer key : keys) {
                    rc.addAll((Collection<String>)this.comments.remove(key));
                }
                if (rc.size() > 0) {
                    return rc;
                }
                return null;
            }
            return this.comments.remove(rowIndex);
        }

        public void registerComment(int rowIndex, String comment) {
            List<String> l = this.comments.get(rowIndex);
            if (l == null) {
                l = new ArrayList<String>();
                this.comments.put(rowIndex, l);
            }
            l.add(comment);
        }

        public Object[] next() {
            return this.next(true);
        }

        private synchronized Object[] next(boolean doRemove) {
            Object[] rc = null;
            if (this.getParsingError() != null) {
                throw this.getParsingError();
            }
            while (this.availableObjects.isEmpty() && !this.parsingStopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.availableObjects.isEmpty()) {
                rc = doRemove ? this.availableObjects.remove(0) : this.availableObjects.get(0);
            }
            this.notify();
            return rc;
        }

        public synchronized void addObject(Object[] o) {
            while (this.availableObjects.size() >= 20) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (o != null) {
                this.availableObjects.add(o);
            } else {
                this.parsingStopped = true;
            }
            this.notify();
        }
    }
}

