/*
 * Decompiled with CFR 0.152.
 */
package csv.util;

import csv.TableReader;
import csv.util.CSVUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BeanReader
implements Iterator<Object> {
    private TableReader reader;
    private boolean evaluateHeaderRow = false;
    private String[] attributes = null;
    private Map<String, Method> methods = new HashMap<String, Method>();
    private Class<?> beanClass;

    public BeanReader(Class<?> beanClass, TableReader reader) {
        this(beanClass, reader, true, null);
    }

    public BeanReader(Class<?> beanClass, TableReader reader, String[] attributes) {
        this(beanClass, reader, false, attributes);
    }

    protected BeanReader(Class<?> beanClass, TableReader reader, boolean evaluateHeaderRow, String[] attributes) {
        this.reader = reader;
        this.evaluateHeaderRow = evaluateHeaderRow;
        if (!evaluateHeaderRow) {
            this.setAttributes(attributes);
        }
        this.beanClass = beanClass;
    }

    @Override
    public boolean hasNext() {
        if (this.isEvaluateHeaderRow() && this.attributes == null) {
            this.readHeaderRow();
        }
        return this.reader.hasNext();
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("End of stream");
        }
        return this.convertToBean((Object[])this.reader.next());
    }

    public void reset() {
        this.reader.reset();
    }

    public void close() {
        this.reader.close();
    }

    public Object convertToBean(Object[] columns) {
        String attribute = null;
        try {
            Object rc = this.beanClass.newInstance();
            for (int i = 0; i < columns.length; ++i) {
                attribute = this.getAttributeName(i);
                if (attribute == null) continue;
                Method m = this.getMethod(attribute);
                m.invoke(rc, columns[i]);
            }
            return rc;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Cannot set attribute: " + attribute, e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Cannot create JavaBean", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot create JavaBean", e);
        }
    }

    @Override
    public void remove() {
        throw new IllegalStateException("Remove not supported");
    }

    public boolean isEvaluateHeaderRow() {
        return this.evaluateHeaderRow;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    protected void setAttributes(String[] attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attribute names cannot be null");
        }
        this.attributes = attributes;
    }

    public void readHeaderRow() {
        if (this.reader.hasHeaderRow()) {
            this.setAttributes(CSVUtils.convertArray(this.reader.getHeaderRow(), 0));
        }
    }

    protected String getAttributeName(int columnIndex) {
        String[] attr = this.getAttributes();
        if (attr == null) {
            return null;
        }
        if (attr.length <= columnIndex) {
            return null;
        }
        return attr[columnIndex];
    }

    protected Method getMethod(String attribute) {
        Method rc = this.methods.get(attribute);
        if (rc == null) {
            Method[] arr;
            String mName = this.getMethodName(attribute);
            for (Method m : arr = this.beanClass.getMethods()) {
                if (!m.getName().equals(mName) || !this.isValidSetterMethod(m)) continue;
                rc = m;
                break;
            }
            if (rc == null) {
                throw new IllegalArgumentException("No setter found for: " + attribute);
            }
            this.methods.put(attribute, rc);
        }
        return rc;
    }

    protected boolean isValidSetterMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        return method.getName().startsWith("set");
    }

    protected String getMethodName(String attribute) {
        return "set" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
    }
}

