/*
 * Decompiled with CFR 0.152.
 */
package csv.util;

import csv.TableWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BeanWriter {
    private TableWriter writer = null;
    private List<String> attributes = null;
    private Map<String, Method> methods = null;
    private boolean writeHeaderRow = true;
    private boolean headerRowWritten = false;

    public BeanWriter(TableWriter writer, boolean writeHeaderRow) {
        this.setWriter(writer);
        this.setWriteHeaderRow(writeHeaderRow);
    }

    public boolean isWriteHeaderRow() {
        return this.writeHeaderRow;
    }

    protected void setWriteHeaderRow(boolean writeHeaderRow) {
        this.writeHeaderRow = writeHeaderRow;
    }

    public void writeBean(Object bean) throws IOException {
        if (this.attributes == null) {
            this.createAttributeList(bean.getClass());
        }
        if (this.isWriteHeaderRow() && !this.headerRowWritten) {
            this.writeHeaderRow();
        }
        this.getWriter().printRow(this.convertToColumns(bean));
    }

    public void close() {
        this.getWriter().close();
    }

    public TableWriter getWriter() {
        return this.writer;
    }

    protected void setWriter(TableWriter writer) {
        this.writer = writer;
    }

    public Object[] convertToColumns(Object bean) {
        if (this.attributes == null) {
            this.createAttributeList(bean.getClass());
        }
        Object[] rc = new Object[this.attributes.size()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = this.getAttribute(i, bean);
        }
        return rc;
    }

    protected Object getAttribute(int index, Object bean) {
        if (this.attributes == null) {
            this.createAttributeList(bean.getClass());
        }
        if (index < 0 || index >= this.attributes.size()) {
            return null;
        }
        String attribute = this.attributes.get(index);
        return this.getAttribute(attribute, bean);
    }

    protected Object getAttribute(String attribute, Object bean) {
        if (attribute == null) {
            return null;
        }
        if (this.attributes == null) {
            this.createAttributeList(bean.getClass());
        }
        Method method = this.methods.get(attribute);
        return this.getAttribute(method, bean);
    }

    protected Object getAttribute(Method method, Object bean) {
        if (bean == null) {
            return null;
        }
        if (method == null) {
            return null;
        }
        try {
            return method.invoke(bean, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Cannot call method", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot call method", e);
        }
    }

    protected void createAttributeList(Class<?> clazz, List<String> attributes) {
        for (String attr : attributes) {
            this.addGetter(clazz, attr);
        }
    }

    protected void createAttributeList(Class<?> clazz, String[] attributes) {
        for (String attr : attributes) {
            this.addGetter(clazz, attr);
        }
    }

    protected void createAttributeList(Class<?> clazz) {
        Method[] methods;
        for (Method m : methods = clazz.getMethods()) {
            if (!this.isValidGetterMethod(m)) continue;
            String attributeName = this.getAttributeName(m);
            this.addGetter(attributeName, m);
        }
    }

    protected void addGetter(Class<?> clazz, String attribute) {
        String mName = "get" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
        try {
            Method m = clazz.getMethod(mName, null);
            if (!this.isValidGetterMethod(m)) {
                throw new IllegalStateException("No JavaBean attribute: " + attribute);
            }
            this.addGetter(attribute, m);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such attribute", e);
        }
    }

    protected boolean isValidGetterMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType == null) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (method.getParameterTypes().length > 0) {
            return false;
        }
        if (method.getName().equals("getClass")) {
            return false;
        }
        if ((returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE)) && method.getName().startsWith("is")) {
            return true;
        }
        return method.getName().startsWith("get");
    }

    protected void addGetter(String attributeName, Method method) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
            this.methods = new HashMap<String, Method>();
        }
        this.attributes.add(attributeName);
        this.methods.put(attributeName, method);
    }

    protected void writeHeaderRow() {
        Object[] row = new String[this.attributes.size()];
        this.attributes.toArray(row);
        try {
            this.getWriter().printRow(row);
        }
        catch (IOException e) {
            throw new IllegalStateException("Header row failed:", e);
        }
        this.headerRowWritten = true;
    }

    protected String getAttributeName(Method m) {
        String rc = m.getName();
        rc = rc.startsWith("is") ? rc.substring(2) : rc.substring(3);
        rc = rc.substring(0, 1).toLowerCase() + rc.substring(1);
        return rc;
    }

    public int writeBeans(Collection<? extends Object> collection) throws IOException {
        return this.writeBeans(collection.iterator());
    }

    public int writeBeans(Iterator<? extends Object> i) throws IOException {
        int rc = 0;
        while (i.hasNext()) {
            this.writeBean(i.next());
            ++rc;
        }
        return rc;
    }

    public int writeBeans(Object[] arr) throws IOException {
        int rc = 0;
        for (Object bean : arr) {
            this.writeBean(bean);
            ++rc;
        }
        return rc;
    }
}

