/*
 * Decompiled with CFR 0.152.
 */
package csv.util;

import csv.CommentCallback;
import csv.TableReader;
import csv.TableWriter;
import csv.impl.JTableReader;
import csv.impl.JdbcReader;
import csv.util.BeanWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class CSVUtils {
    public static void copyHeader(ResultSet resultSet, TableWriter writer) throws Exception {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colLength = metaData.getColumnCount();
        Object[] row = new String[colLength];
        for (int i = 0; i < colLength; ++i) {
            row[i] = metaData.getColumnLabel(i + 1);
        }
        writer.printRow(row);
    }

    public static void copy(ResultSet resultSet, TableWriter writer, boolean writeHeaderRow) throws Exception {
        JdbcReader reader = new JdbcReader(resultSet);
        CSVUtils.copy(reader, writer, writeHeaderRow);
    }

    public static void copyTableHeader(JTableHeader tableHeader, TableWriter writer) throws Exception {
        TableColumnModel cModel = tableHeader.getColumnModel();
        int colLength = cModel.getColumnCount();
        Object[] row = new String[colLength];
        for (int i = 0; i < colLength; ++i) {
            Object o = cModel.getColumn(i).getHeaderValue();
            row[i] = o != null ? o.toString() : null;
        }
        writer.printRow(row);
    }

    public static void copy(JTable table, TableWriter writer, boolean writeHeaderRow, boolean selectedOnly) throws Exception {
        JTableReader reader = new JTableReader(table, selectedOnly);
        CSVUtils.copy(reader, writer, writeHeaderRow);
    }

    public static void copy(TableReader reader, TableWriter writer) throws Exception {
        CSVUtils.copy(reader, writer, false);
    }

    public static void copy(TableReader reader, TableWriter writer, boolean copyHeaderRow) throws Exception {
        CopyCommentCallback callback = new CopyCommentCallback(writer);
        reader.registerCommentCallBack(callback);
        if (copyHeaderRow && reader.hasHeaderRow()) {
            writer.printRow(reader.getHeaderRow());
        }
        while (reader.hasNext()) {
            writer.printRow((Object[])reader.next());
        }
        reader.unregisterCommentCallBack(callback);
    }

    public static int copy(Collection<? extends Object[]> collection, TableWriter writer) throws IOException {
        return CSVUtils.copy(collection.iterator(), writer);
    }

    public static int copy(Iterator<? extends Object[]> i, TableWriter writer) throws IOException {
        int rc = 0;
        while (i.hasNext()) {
            writer.printRow(i.next());
            ++rc;
        }
        return rc;
    }

    public static int copy(Object[][] arr, TableWriter writer) throws IOException {
        int rc = 0;
        for (Object[] row : arr) {
            writer.printRow(row);
            ++rc;
        }
        return rc;
    }

    public static int copyBeans(Collection<? extends Object> collection, TableWriter writer) throws IOException {
        return CSVUtils.copyBeans(collection.iterator(), writer);
    }

    public static int copyBeans(Iterator<? extends Object> i, TableWriter writer) throws IOException {
        BeanWriter w = new BeanWriter(writer, true);
        int rc = w.writeBeans(i);
        w.close();
        return rc;
    }

    public static int copyBeans(Object[] arr, TableWriter writer) throws IOException {
        BeanWriter w = new BeanWriter(writer, true);
        int rc = w.writeBeans(arr);
        w.close();
        return rc;
    }

    public static String[] convertArray(Object[] columns, int minLength) {
        int colcount;
        int n = colcount = minLength > 0 ? minLength : 0;
        if (columns != null) {
            colcount = columns.length;
        }
        String[] rc = new String[Math.max(colcount, minLength)];
        if (colcount > 0) {
            for (int i = 0; i < colcount; ++i) {
                rc[i] = columns[i] != null ? columns[i].toString() : null;
            }
        }
        return rc;
    }

    public static Object[] extendArray(Object[] columns, int minLength) {
        int colcount;
        int n = colcount = minLength > 0 ? minLength : 0;
        if (columns != null) {
            colcount = columns.length;
        }
        Object[] rc = new Object[Math.max(colcount, minLength)];
        if (colcount > 0) {
            for (int i = 0; i < colcount; ++i) {
                rc[i] = columns[i];
            }
        }
        return rc;
    }

    public static String[] extendArray(String[] columns, int minLength) {
        int colcount;
        int n = colcount = minLength > 0 ? minLength : 0;
        if (columns != null) {
            colcount = columns.length;
        }
        String[] rc = new String[Math.max(colcount, minLength)];
        if (colcount > 0) {
            for (int i = 0; i < colcount; ++i) {
                rc[i] = columns[i];
            }
        }
        return rc;
    }

    public static Object[] convertList(List<Object> columns, int minLength) {
        int colcount;
        int n = colcount = minLength > 0 ? minLength : 0;
        if (columns != null) {
            colcount = columns.size();
        }
        Object[] rc = new Object[Math.max(colcount, minLength)];
        if (colcount > 0) {
            for (int i = 0; i < colcount; ++i) {
                rc[i] = columns.get(i);
            }
        }
        return rc;
    }

    private static class CopyCommentCallback
    implements CommentCallback {
        private TableWriter writer = null;

        public CopyCommentCallback(TableWriter writer) {
            this.writer = writer;
        }

        @Override
        public void comment(TableReader reader, String comment, int row, int cell) {
            try {
                this.writer.printComment(comment, row, cell);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

