/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp.project.assertfixer;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import eu.stamp.project.assertfixer.Configuration;
import eu.stamp.project.assertfixer.util.Util;
import java.util.Arrays;

public class JSAPConfiguration
extends Configuration {
    private static final JSAP jsap = JSAPConfiguration.initJSAP();

    private JSAPConfiguration(String[] args) {
        JSAPResult options = jsap.parse(args);
        if (options.getBoolean("help")) {
            JSAPConfiguration.usage();
        }
        this.setClasspath(options.getString("classpath"));
        this.setFullQualifiedFailingTestClass(options.getString("testClass"));
        this.setFailingTestMethods(Arrays.asList(options.getString("testMethod").split(":")));
        this.setPathToSourceFolder(options.getString("sourcePath"));
        this.setPathToTestFolder(options.getString("testPath"));
        this.setVerbose(options.getBoolean("verbose"));
        this.setOutput(options.getString("output"));
    }

    public static JSAPConfiguration get(String[] args) {
        return new JSAPConfiguration(args);
    }

    private static JSAP initJSAP() {
        JSAP jsap = new JSAP();
        FlaggedOption classpath = new FlaggedOption("classpath");
        classpath.setLongFlag("classpath");
        classpath.setShortFlag('c');
        classpath.setHelp("[Mandatory] Use must specify a complete classpath to execute tests on your project." + Util.LINE_SEPARATOR + "The classpath should be formatted according to the OS.");
        classpath.setStringParser((StringParser)JSAP.STRING_PARSER);
        classpath.setAllowMultipleDeclarations(false);
        classpath.setRequired(true);
        FlaggedOption testClass = new FlaggedOption("testClass");
        testClass.setLongFlag("test-class");
        testClass.setShortFlag('t');
        testClass.setHelp("[Mandatory] Use must specify a failing test class." + Util.LINE_SEPARATOR + "You must provide a full qualified name such as: my.package.example.ClassTest");
        testClass.setStringParser((StringParser)JSAP.STRING_PARSER);
        testClass.setAllowMultipleDeclarations(false);
        testClass.setRequired(true);
        FlaggedOption testMethod = new FlaggedOption("testMethod");
        testMethod.setLongFlag("test-method");
        testMethod.setShortFlag('m');
        testMethod.setHelp("[Mandatory] Use must specify at least one failing test method." + Util.LINE_SEPARATOR + "Separate multiple values with \":\" such as: test1:test2");
        testMethod.setStringParser((StringParser)JSAP.STRING_PARSER);
        testMethod.setAllowMultipleDeclarations(false);
        testMethod.setRequired(true);
        FlaggedOption sourcePath = new FlaggedOption("sourcePath");
        sourcePath.setLongFlag("source-path");
        sourcePath.setShortFlag('s');
        sourcePath.setHelp("[Optional] Specify the path to the source folder.");
        sourcePath.setStringParser((StringParser)JSAP.STRING_PARSER);
        sourcePath.setAllowMultipleDeclarations(false);
        sourcePath.setRequired(false);
        FlaggedOption testPath = new FlaggedOption("testPath");
        testPath.setLongFlag("test-path");
        testPath.setShortFlag('p');
        testPath.setHelp("Specify the path to the test source folder.");
        testPath.setStringParser((StringParser)JSAP.STRING_PARSER);
        testPath.setAllowMultipleDeclarations(false);
        testPath.setDefault("src/test/java/");
        Switch verbose = new Switch("verbose");
        verbose.setLongFlag("verbose");
        verbose.setHelp("Enable verbose mode");
        verbose.setDefault("false");
        FlaggedOption output = new FlaggedOption("output");
        output.setLongFlag("output");
        output.setShortFlag('o');
        output.setHelp("[Optional] Specify an output folder for result and temporary files.");
        output.setDefault("target/assert-fixer");
        output.setStringParser((StringParser)JSAP.STRING_PARSER);
        output.setAllowMultipleDeclarations(false);
        Switch help = new Switch("help");
        help.setLongFlag("help");
        help.setShortFlag('h');
        help.setHelp("Display this help and exit");
        help.setDefault("false");
        try {
            jsap.registerParameter((Parameter)classpath);
            jsap.registerParameter((Parameter)testClass);
            jsap.registerParameter((Parameter)testMethod);
            jsap.registerParameter((Parameter)sourcePath);
            jsap.registerParameter((Parameter)testPath);
            jsap.registerParameter((Parameter)verbose);
            jsap.registerParameter((Parameter)output);
            jsap.registerParameter((Parameter)help);
        }
        catch (JSAPException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            JSAPConfiguration.usage();
        }
        return jsap;
    }

    private static void usage() {
        System.err.println("                          " + jsap.getUsage());
        System.err.println();
        System.err.println(jsap.getHelp());
        System.exit(1);
    }
}

