/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp.project.assertfixer.asserts;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.algorithm.DiffException;
import com.github.difflib.patch.Patch;
import eu.stamp.project.assertfixer.AssertFixerResult;
import eu.stamp.project.assertfixer.Configuration;
import eu.stamp.project.assertfixer.asserts.AssertionReplacer;
import eu.stamp.project.assertfixer.asserts.AssertionsFixer;
import eu.stamp.project.assertfixer.asserts.TryCatchFixer;
import eu.stamp.project.assertfixer.asserts.log.Logger;
import eu.stamp.project.assertfixer.test.TestRunner;
import eu.stamp.project.assertfixer.util.Counter;
import eu.stamp.project.assertfixer.util.Util;
import eu.stamp.project.testrunner.EntryPoint;
import eu.stamp.project.testrunner.runner.test.Failure;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import spoon.Launcher;
import spoon.SpoonModelBuilder;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtTry;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class AssertFixer {
    public static AssertFixerResult fixAssert(Configuration configuration, Launcher spoon, CtClass originalClass, String testCaseName, Failure failure, String cp) throws MalformedURLException, ClassNotFoundException {
        CtClass classTestToBeFixed = originalClass.clone();
        String originalClassStr = originalClass.toString();
        String filePath = originalClass.getPosition().getFile().getPath();
        String basePath = new File(".").getPath();
        String relativeFilePath = new File(basePath).toURI().relativize(new File(filePath).toURI()).getPath();
        CtPackage parentPackage = originalClass.getPackage();
        parentPackage.removeType((CtType)originalClass);
        parentPackage.addType((CtType)classTestToBeFixed);
        String testClassName = originalClass.getQualifiedName();
        AssertFixerResult result = new AssertFixerResult(testClassName, testCaseName);
        CtMethod testCaseToBeFix = (CtMethod)classTestToBeFixed.getMethodsByName(testCaseName).get(0);
        Counter.addNumberOfAssertionInTests(testCaseToBeFix.getElements((Filter)new TypeFilter<CtInvocation>(CtInvocation.class){

            public boolean matches(CtInvocation element) {
                return Util.isAssert.test(element);
            }
        }).size());
        if (Util.assertionErrors.contains(failure.fullQualifiedNameOfException)) {
            Counter.incNumberOfFailingAssertion();
            Counter.incNumberOfFailingTestFromAssertion();
            CtMethod clone = testCaseToBeFix.clone();
            classTestToBeFixed.removeMethod(testCaseToBeFix);
            classTestToBeFixed.addMethod(clone);
            if (failure.messageOfFailure != null && failure.messageOfFailure.startsWith("Expecting exception: ") && failure.messageOfFailure.endsWith("Exception")) {
                AssertFixer.removeExpectedException(configuration, spoon, testClassName, testCaseName, cp, clone);
            } else if (failure.messageOfFailure != null && !failure.messageOfFailure.contains("expected")) {
                String message = "AssertFixer cannot fix this assertion. Message of failure: " + failure.messageOfFailure;
                result.setSuccess(false);
                result.setExceptionMessage(message);
            } else {
                List<Integer> indexToLog = AssertionReplacer.replaceByLogStatement(clone);
                TestRunner.runTestWithLogger(configuration, spoon, cp, testClassName, testCaseName);
                Logger.load();
                classTestToBeFixed.removeMethod(clone);
                classTestToBeFixed.addMethod(testCaseToBeFix);
                AssertionsFixer.fixAssertion(spoon.getFactory(), testCaseToBeFix, indexToLog);
            }
        } else {
            Counter.incNumberOfFailingTestFromException();
            List catches = testCaseToBeFix.getElements((Filter)new TypeFilter(CtCatch.class));
            if (!catches.isEmpty()) {
                TryCatchFixer.fixTryCatchFailAssertion(spoon, testCaseToBeFix, failure, catches);
            } else {
                TryCatchFixer.addTryCatchFailAssertion(spoon, testCaseToBeFix, failure);
            }
        }
        SpoonModelBuilder compiler = spoon.createCompiler();
        compiler.setBinaryOutputDirectory(new File(configuration.getBinaryOutputDirectory()));
        compiler.compile(new SpoonModelBuilder.InputType[]{SpoonModelBuilder.InputType.CTTYPES});
        boolean success = EntryPoint.runTests((String)(configuration.getBinaryOutputDirectory() + Util.PATH_SEPARATOR + configuration.getClasspath()), (String)testClassName, (String[])new String[]{testCaseName}).getFailingTests().isEmpty();
        String diff = AssertFixer.computeDiff(originalClassStr, classTestToBeFixed.toString(), relativeFilePath);
        result.setDiff(diff);
        result.setSuccess(success);
        parentPackage.removeType((CtType)classTestToBeFixed);
        parentPackage.addType((CtType)originalClass);
        return result;
    }

    private static String computeDiff(String oldClassStr, String newClassStr, String filePath) {
        List<String> oldClassLines = Arrays.asList(oldClassStr.split("\\n"));
        List<String> newClassLines = Arrays.asList(newClassStr.split("\\n"));
        try {
            Patch patch = DiffUtils.diff(oldClassLines, newClassLines);
            List strings = UnifiedDiffUtils.generateUnifiedDiff((String)filePath, (String)filePath, oldClassLines, (Patch)patch, (int)0);
            return StringUtils.join((Iterable)strings, (String)"\n");
        }
        catch (DiffException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static void removeExpectedException(Configuration configuration, Launcher spoon, String fullQualifiedName, String testCaseName, String cp, CtMethod<?> clone) {
        CtTry ctTry = (CtTry)clone.getElements((Filter)new TypeFilter(CtTry.class)).get(0);
        ctTry.replace((CtElement)ctTry.getBody());
        CtInvocation failToRemove = clone.getElements((Filter)new TypeFilter(CtInvocation.class)).stream().filter(Util.isFail).findFirst().orElseThrow(RuntimeException::new);
        boolean remove = ((CtBlock)failToRemove.getParent(CtBlock.class)).getStatements().remove(failToRemove);
        if (!remove) {
            throw new RuntimeException();
        }
        TestRunner.runTest(configuration, spoon, fullQualifiedName, testCaseName);
    }
}

