/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp.project.assertfixer.asserts;

import eu.stamp.project.assertfixer.util.Util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class AssertionReplacer {
    static List<Integer> replaceByLogStatement(CtMethod<?> clone) {
        List<CtInvocation> assertionsToBeReplaced = clone.getElements((Filter)new TypeFilter<CtInvocation>(CtInvocation.class){

            public boolean matches(CtInvocation element) {
                return Util.isAssert.test(element) && super.matches((CtElement)element);
            }
        }).stream().sorted(Comparator.comparingInt(ctInvocation -> ctInvocation.getPosition().getLine())).collect(Collectors.toList());
        ArrayList<Integer> indices = new ArrayList<Integer>();
        assertionsToBeReplaced.forEach(assertionToBeReplaced -> {
            int index = ((CtBlock)assertionToBeReplaced.getParent(CtBlock.class)).getStatements().indexOf(assertionToBeReplaced);
            indices.add(index);
            String snippet = "eu.stamp.project.assertfixer.asserts.log.Logger.log(";
            if (assertionToBeReplaced.getExecutable().getSimpleName().endsWith("True") || assertionToBeReplaced.getExecutable().getSimpleName().endsWith("False")) {
                assertionToBeReplaced.replace((CtElement)clone.getFactory().createCodeSnippetStatement(snippet + index + "," + assertionToBeReplaced.getArguments().get(0) + ")"));
            } else {
                assertionToBeReplaced.replace((CtElement)clone.getFactory().createCodeSnippetStatement(snippet + index + "," + assertionToBeReplaced.getArguments().get(1) + ")"));
            }
        });
        return indices;
    }
}

