/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp.project.assertfixer.asserts;

import eu.stamp.project.assertfixer.asserts.log.Logger;
import eu.stamp.project.assertfixer.util.Counter;
import eu.stamp.project.assertfixer.util.Util;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtVariableReference;

public class AssertionsFixer {
    static void fixAssertion(Factory factory, CtMethod<?> testCaseToBeFix, List<Integer> indices) {
        indices.forEach(index -> {
            boolean replaced = false;
            CtElement valueToReplace = (CtElement)((CtInvocation)testCaseToBeFix.getBody().getStatement(index.intValue())).getArguments().get(0);
            CtComment comment = factory.createComment("AssertFixer: old assertion " + testCaseToBeFix.getBody().getStatement(index.intValue()).toString(), CtComment.CommentType.INLINE);
            if (Logger.observations.containsKey(index)) {
                if (Logger.observations.get(index) != null && Logger.observations.get(index).getClass().isArray()) {
                    if (Util.isPrimitiveArray.test(Logger.observations.get(index))) {
                        String snippet = AssertionsFixer.createSnippetFromObservations(Logger.observations.get(index));
                        valueToReplace.replace((CtElement)factory.createCodeSnippetExpression(snippet));
                        Counter.incNumberOfArrayFixed();
                        replaced = true;
                    }
                } else if (!(valueToReplace instanceof CtLiteral) || !Logger.observations.get(index).equals(((CtLiteral)valueToReplace).getValue())) {
                    if (Logger.observations.get(index) instanceof Boolean) {
                        String snippet = ((CtInvocation)testCaseToBeFix.getBody().getStatement(index.intValue())).getTarget().toString() + ".assert" + Logger.observations.get(index).toString().toUpperCase().substring(0, 1) + Logger.observations.get(index).toString().substring(1) + "(" + valueToReplace + ")";
                        testCaseToBeFix.getBody().getStatement(index.intValue()).replace((CtElement)factory.createCodeSnippetStatement(snippet));
                    } else if ("assertSame".equals(((CtInvocation)valueToReplace.getParent()).getExecutable().getSimpleName())) {
                        ((CtInvocation)valueToReplace.getParent()).replace((CtElement)factory.createCodeSnippetStatement(valueToReplace.getParent().toString().replace("assertSame", "assertNotSame")));
                    } else if ("assertNotSame".equals(((CtInvocation)valueToReplace.getParent()).getExecutable().getSimpleName())) {
                        ((CtInvocation)valueToReplace.getParent()).replace((CtElement)factory.createCodeSnippetStatement(valueToReplace.getParent().toString().replace("assertSame", "assertSame")));
                    } else if (Util.isFieldOfClass.test(Logger.observations.get(index))) {
                        valueToReplace.replace((CtElement)factory.createCodeSnippetExpression(Util.fieldOfObjectToString.apply(Logger.observations.get(index))));
                    } else if (Logger.observations.get(index).equals(Double.NEGATIVE_INFINITY)) {
                        CtFieldRead fieldNegativeInfinity = factory.createFieldRead();
                        fieldNegativeInfinity.setType(factory.createCtTypeReference(Double.class));
                        CtField negative_infinity = factory.Class().get(Double.class).getField("NEGATIVE_INFINITY");
                        fieldNegativeInfinity.setVariable((CtVariableReference)negative_infinity.getReference());
                        fieldNegativeInfinity.setFactory(factory);
                        valueToReplace.replace((CtElement)fieldNegativeInfinity);
                    } else if (Logger.observations.get(index).equals(Double.POSITIVE_INFINITY)) {
                        CtFieldRead fieldPositiveInfinity = factory.createFieldRead();
                        fieldPositiveInfinity.setType(factory.createCtTypeReference(Double.class));
                        CtField positive_infinity = factory.Class().get(Double.class).getField("POSITIVE_INFINITY");
                        fieldPositiveInfinity.setVariable((CtVariableReference)positive_infinity.getReference());
                        fieldPositiveInfinity.setFactory(factory);
                        valueToReplace.replace((CtElement)fieldPositiveInfinity);
                    } else {
                        valueToReplace.replace((CtElement)factory.createLiteral(Logger.observations.get(index)));
                        Counter.incNumberOfPrimitivesValuesFixed();
                    }
                    replaced = true;
                }
                if (replaced) {
                    testCaseToBeFix.getBody().getStatement(index.intValue()).addComment(comment);
                }
            }
        });
        Logger.reset();
    }

    static String createSnippetFromObservations(Object o) {
        String snippet = "new " + o.getClass().getSimpleName() + "{ ";
        if (o instanceof int[]) {
            snippet = snippet + Arrays.stream((int[])o).mapToObj(v -> v).map(Object::toString).collect(Collectors.joining(","));
        } else if (o instanceof double[]) {
            snippet = snippet + Arrays.stream((double[])o).mapToObj(v -> v).map(Object::toString).collect(Collectors.joining(","));
        } else if (o instanceof long[]) {
            snippet = snippet + Arrays.stream((long[])o).mapToObj(v -> v).map(Object::toString).collect(Collectors.joining(","));
        }
        return snippet + "}";
    }
}

