/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp.project.assertfixer.asserts;

import eu.stamp.project.testrunner.runner.test.Failure;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import spoon.Launcher;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class TryCatchFixer {
    private static Predicate<String> isAnonymous = fullQualifiedName -> Pattern.compile("(.+)\\$\\d+").matcher((CharSequence)fullQualifiedName).matches();
    static final String PREFIX_NAME_EXPECTED_EXCEPTION = "expectedException__";
    static final String PREFIX_MESSAGE_EXPECTED_EXCEPTION = "Expecting exception: ";
    static final String NAME_FAIL_METHOD = "fail";

    static void fixTryCatchFailAssertion(Launcher spoon, CtMethod<?> testCaseToBeFix, Failure failure, final List<CtCatch> catches) {
        String fullQualifiedNameException = failure.fullQualifiedNameOfException;
        CtTypeReference reference = testCaseToBeFix.getFactory().Type().createReference(fullQualifiedNameException);
        String[] splittedNameException = fullQualifiedNameException.split("\\.");
        String exceptionName = splittedNameException[splittedNameException.length - 1];
        if (isAnonymous.test(failure.fullQualifiedNameOfException)) {
            reference = testCaseToBeFix.getFactory().Type().createReference(fullQualifiedNameException).getSuperclass();
        }
        CtCatchVariable catchVariable = testCaseToBeFix.getFactory().createCatchVariable(reference, PREFIX_NAME_EXPECTED_EXCEPTION + exceptionName, new ModifierKind[0]);
        if (!catches.get(0).getBody().getStatements().isEmpty()) {
            catches.get(0).getBody().getElements((Filter)new TypeFilter<CtVariableAccess>(CtVariableAccess.class){

                public boolean matches(CtVariableAccess element) {
                    return element.getVariable().getDeclaration().equals(((CtCatch)catches.get(0)).getParameter()) && super.matches((CtElement)element);
                }
            }).forEach(variableAccess -> variableAccess.replace((CtElement)spoon.getFactory().createVariableRead((CtVariableReference)catchVariable.getReference(), false)));
        }
        catches.get(0).setParameter(catchVariable);
        List failInvocation = testCaseToBeFix.getElements((Filter)new TypeFilter<CtInvocation>(CtInvocation.class){

            public boolean matches(CtInvocation element) {
                return element.getExecutable() != null && element.getExecutable().getDeclaringType() != null && "Assert".equals(element.getExecutable().getDeclaringType().getSimpleName()) && TryCatchFixer.NAME_FAIL_METHOD.equals(element.getExecutable().getSimpleName()) && super.matches((CtElement)element);
            }
        });
        if (!failInvocation.isEmpty() && ((CtTry)((CtInvocation)failInvocation.get(0)).getParent(CtTry.class)).getCatchers().contains(catches.get(0))) {
            ((CtLiteral)((CtInvocation)failInvocation.get(0)).getArguments().get(0)).replace((CtElement)spoon.getFactory().createLiteral((Object)(PREFIX_MESSAGE_EXPECTED_EXCEPTION + exceptionName)));
        }
    }

    static void addTryCatchFailAssertion(Launcher spoon, CtMethod<?> testCaseToBeFix, Failure failure) {
        Factory factory = spoon.getFactory();
        CtTry aTry = factory.createTry();
        CtCatch aCatch = factory.createCatch();
        aTry.addCatcher(aCatch);
        String fullQualifiedNameException = failure.fullQualifiedNameOfException;
        CtTypeReference reference = testCaseToBeFix.getFactory().Type().createReference(fullQualifiedNameException);
        String[] splittedNameException = fullQualifiedNameException.split("\\.");
        String exceptionName = splittedNameException[splittedNameException.length - 1];
        if (isAnonymous.test(failure.fullQualifiedNameOfException)) {
            reference = testCaseToBeFix.getFactory().Type().createReference(fullQualifiedNameException).getSuperclass();
        }
        CtCatchVariable catchVariable = testCaseToBeFix.getFactory().createCatchVariable(reference, PREFIX_NAME_EXPECTED_EXCEPTION + exceptionName, new ModifierKind[0]);
        aCatch.setParameter(catchVariable);
        aCatch.setBody((CtStatement)factory.createCodeSnippetStatement("org.junit.Assert.assertTrue(true)"));
        aTry.setBody(testCaseToBeFix.getBody().getStatement(0));
        for (int i = 1; i < testCaseToBeFix.getBody().getStatements().size(); ++i) {
            aTry.getBody().addStatement(testCaseToBeFix.getBody().getStatement(i));
        }
        aTry.getBody().addStatement((CtStatement)factory.createCodeSnippetStatement("org.junit.Assert.fail(\"Expecting exception: " + exceptionName + "\")"));
        testCaseToBeFix.setBody((CtStatement)aTry);
    }
}

