/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp.project.assertfixer.test;

import eu.stamp.project.assertfixer.Configuration;
import eu.stamp.project.assertfixer.asserts.log.Logger;
import eu.stamp.project.assertfixer.util.Util;
import eu.stamp.project.testrunner.EntryPoint;
import eu.stamp.project.testrunner.runner.test.TestListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.IntStream;
import org.junit.AfterClass;
import spoon.Launcher;
import spoon.SpoonModelBuilder;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Filter;
import spoon.reflect.visitor.filter.TypeFilter;

public class TestRunner {
    public static TestListener runTest(Configuration configuration, Launcher launcher, String failingTestClass, String failingTestMethod) {
        SpoonModelBuilder compiler = launcher.createCompiler();
        compiler.setBinaryOutputDirectory(new File(configuration.getBinaryOutputDirectory()));
        compiler.compile(new SpoonModelBuilder.InputType[]{SpoonModelBuilder.InputType.CTTYPES});
        return EntryPoint.runTests((String)(configuration.getBinaryOutputDirectory() + Util.PATH_SEPARATOR + configuration.getClasspath()), (String)failingTestClass, (String[])new String[]{failingTestMethod});
    }

    public static void runTestWithLogger(Configuration configuration, Launcher spoon, String classpath, String fullQualifiedName, String testCaseName) {
        final Factory factory = spoon.getFactory();
        CtClass testClass = factory.Class().get(fullQualifiedName);
        CtElement addedElement = TestRunner.addSaveStatementInTearDownAfterClass(testClass);
        String loggerClasspath = ":target/classes/eu/stamp/project/assertfixer/log/Logger.class";
        String binaryOutputDirectory = configuration.getBinaryOutputDirectory();
        SpoonModelBuilder compiler = spoon.createCompiler();
        CtMethod ctMethod = (CtMethod)testClass.getMethodsByName(testCaseName).get(0);
        ArrayList addedMethod = new ArrayList();
        IntStream.range(0, 2).forEach(index -> {
            CtMethod clone = ctMethod.clone();
            clone.setSimpleName(clone.getSimpleName() + "_" + index);
            testClass.addMethod(clone);
            addedMethod.add(clone);
        });
        compiler.setBinaryOutputDirectory(new File(configuration.getBinaryOutputDirectory()));
        compiler.compile(new SpoonModelBuilder.InputType[]{SpoonModelBuilder.InputType.CTTYPES});
        EntryPoint.runTests((String)(binaryOutputDirectory + Util.PATH_SEPARATOR + classpath + ":target/classes/eu/stamp/project/assertfixer/log/Logger.class"), (String)fullQualifiedName, (String[])new String[]{testCaseName, testCaseName + "_0", testCaseName + "_1"});
        addedMethod.forEach(arg_0 -> ((CtClass)testClass).removeMethod(arg_0));
        if (addedElement instanceof CtMethod) {
            testClass.removeMethod((CtMethod)addedElement);
        } else {
            CtMethod testDownAfterClass = (CtMethod)testClass.filterChildren((Filter)new TypeFilter<CtMethod>(CtMethod.class){

                public boolean matches(CtMethod element) {
                    return element.getAnnotations().contains(factory.Annotation().get(AfterClass.class));
                }
            }).first();
            testDownAfterClass.getBody().removeStatement((CtStatement)addedElement);
        }
    }

    private static CtElement addSaveStatementInTearDownAfterClass(CtClass<?> testClass) {
        final Factory factory = testClass.getFactory();
        CtMethod<?> testDownAfterClass = (CtMethod<?>)testClass.filterChildren((Filter)new TypeFilter<CtMethod>(CtMethod.class){

            public boolean matches(CtMethod element) {
                return element.getAnnotations().contains(factory.Annotation().get(AfterClass.class));
            }
        }).first();
        boolean methodCreated = false;
        if (testDownAfterClass == null) {
            methodCreated = true;
            testDownAfterClass = TestRunner.initializeTestDownAfterClassMethod(factory, testClass);
        }
        CtType loggerType = factory.Type().get(Logger.class);
        CtMethod save = (CtMethod)loggerType.getMethodsByName("save").get(0);
        CtInvocation invocation = factory.createInvocation((CtExpression)factory.Code().createTypeAccess(loggerType.getReference()), save.getReference(), new CtExpression[0]);
        testDownAfterClass.getBody().insertEnd((CtStatement)invocation);
        if (methodCreated) {
            return testDownAfterClass;
        }
        return invocation;
    }

    private static CtMethod<?> initializeTestDownAfterClassMethod(Factory factory, CtClass<?> testClass) {
        CtType loggerType = factory.Type().get(Logger.class);
        CtMethod save = (CtMethod)loggerType.getMethodsByName("save").get(0);
        CtMethod tearDownAfterClass = factory.createMethod(testClass, new HashSet<ModifierKind>(Arrays.asList(ModifierKind.PUBLIC, ModifierKind.STATIC)), factory.Type().VOID_PRIMITIVE, "tearDownAfterClass", Collections.emptyList(), Collections.emptySet(), factory.createCtBlock((CtStatement)factory.createInvocation((CtExpression)factory.Code().createTypeAccess(loggerType.getReference()), save.getReference(), new CtExpression[0])));
        CtAnnotation annotation = factory.createAnnotation();
        CtTypeReference reference = factory.Type().createReference(AfterClass.class);
        annotation.setAnnotationType(reference);
        tearDownAfterClass.addAnnotation(annotation);
        return tearDownAfterClass;
    }
}

