/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp.project.assertfixer.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.stamp.project.assertfixer.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Counter {
    private static Counter _instance;
    private int initialNumberOfTest = 0;
    private int initialNumberOfFailingTestFromException = 0;
    private int initialNumbernumberOfFailingTestFromAssertion = 0;
    private List<Integer> distributionOfNumberOfAssertionsByTests = new ArrayList<Integer>();
    private int numberOfFixedTests = 0;
    private int numberOfNotFixedTests = 0;
    private int numberOfPrimitivesValuesFixed = 0;
    private int numberOfArrayFixed = 0;
    private int numberOfFailingAssertion = 0;
    private List<Integer> numberOfFailingAssertionInTests = new ArrayList<Integer>();

    private static Counter _getInstance() {
        if (_instance == null) {
            _instance = new Counter();
        }
        return _instance;
    }

    private Counter() {
    }

    public static void incNumberOfTest() {
        ++Counter._getInstance().initialNumberOfTest;
    }

    public static void incNumberOfFailingTestFromException() {
        ++Counter._getInstance().initialNumberOfFailingTestFromException;
    }

    public static void incNumberOfFailingTestFromAssertion() {
        ++Counter._getInstance().initialNumbernumberOfFailingTestFromAssertion;
    }

    public static void addNumberOfAssertionInTests(Integer number) {
        Counter._getInstance().distributionOfNumberOfAssertionsByTests.add(number);
    }

    public static void incNumberOfFailingAssertion() {
        ++Counter._getInstance().numberOfFailingAssertion;
    }

    public static void updateNumberOfFailingAssertionInTests() {
        Counter._getInstance().numberOfFailingAssertionInTests.add(Counter._getInstance().numberOfFailingAssertion);
        Counter._getInstance().numberOfFailingAssertion = 0;
    }

    public static void incNumberOfFixedTests() {
        ++Counter._getInstance().numberOfFixedTests;
    }

    public static void incNumberOfNotFixedTests() {
        ++Counter._getInstance().numberOfNotFixedTests;
    }

    public static void incNumberOfPrimitivesValuesFixed() {
        ++Counter._getInstance().numberOfPrimitivesValuesFixed;
    }

    public static void incNumberOfArrayFixed() {
        ++Counter._getInstance().numberOfArrayFixed;
    }

    public static void reset() {
        _instance = null;
    }

    public static void print() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!new File("output").exists()) {
            new File("output").mkdir();
        }
        try (FileWriter writer = new FileWriter(new File("output" + Util.FILE_SEPARATOR + "metrics.json"), false);){
            JSONMetrics jsonMetrics = new JSONMetrics(Counter._getInstance().initialNumberOfTest, Counter._getInstance().initialNumberOfFailingTestFromException + Counter._getInstance().initialNumbernumberOfFailingTestFromAssertion, Counter._getInstance().initialNumberOfFailingTestFromException, Counter._getInstance().initialNumbernumberOfFailingTestFromAssertion, Counter._getInstance().distributionOfNumberOfAssertionsByTests.stream().map(Object::toString).collect(Collectors.joining(",")), Counter._getInstance().numberOfFixedTests, Counter._getInstance().numberOfNotFixedTests, Counter._getInstance().numberOfPrimitivesValuesFixed, Counter._getInstance().numberOfArrayFixed, Counter._getInstance().numberOfFailingAssertionInTests.stream().map(Object::toString).collect(Collectors.joining(",")));
            writer.write(gson.toJson((Object)jsonMetrics));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class JSONMetrics {
        public final int initialNumberOfTest;
        public final int initialNumberOfFailingTest;
        public final int initialNumberOfFailingTestFromException;
        public final int initialNumberOfFailingTestFromAssertion;
        public final String distributionOfNumberOfAssertionsByTests;
        public final int numberOfFixedTests;
        public final int numberOfNotFixedTests;
        public final int numberOfPrimitivesValuesFixed;
        public final int numberOfArrayFixed;
        public final String numberOfFailingAssertionInTests;

        public JSONMetrics(int initialNumberOfTest, int initialNumberOfFailingTest, int initialNumberOfFailingTestFromException, int initialNumberOfFailingTestFromAssertion, String distributionOfNumberOfAssertionsByTests, int numberOfFixedTests, int numberOfNotFixedTests, int numberOfPrimitivesValuesFixed, int numberOfArrayFixed, String numberOfFailingAssertionInTests) {
            this.initialNumberOfTest = initialNumberOfTest;
            this.initialNumberOfFailingTest = initialNumberOfFailingTest;
            this.initialNumberOfFailingTestFromException = initialNumberOfFailingTestFromException;
            this.initialNumberOfFailingTestFromAssertion = initialNumberOfFailingTestFromAssertion;
            this.distributionOfNumberOfAssertionsByTests = distributionOfNumberOfAssertionsByTests;
            this.numberOfFixedTests = numberOfFixedTests;
            this.numberOfNotFixedTests = numberOfNotFixedTests;
            this.numberOfPrimitivesValuesFixed = numberOfPrimitivesValuesFixed;
            this.numberOfArrayFixed = numberOfArrayFixed;
            this.numberOfFailingAssertionInTests = numberOfFailingAssertionInTests;
        }
    }
}

