/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp.project.assertfixer.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtType;

public class Util {
    public static final List<String> assertionErrors = new ArrayList<String>();
    public static final Function<Object, String> fieldOfObjectToString;
    public static final Predicate<Object> isFieldOfClass;
    public static final Predicate<Object> isPrimitiveArray;
    public static final Predicate<CtInvocation> isFail;
    public static final Predicate<CtInvocation> isAssert;
    public static final String PATH_SEPARATOR;
    public static final String LINE_SEPARATOR;
    public static final String FILE_SEPARATOR;

    public static boolean isAssertionClass(CtType klass) {
        return klass != null && ("org.junit.Assert".equals(klass.getQualifiedName()) || "junit.framework.Assert".equals(klass.getQualifiedName())) && klass.getSuperclass() != null && Util.isAssertionClass(klass.getSuperclass().getDeclaration());
    }

    static {
        assertionErrors.add("java.lang.AssertionError");
        assertionErrors.add("org.junit.internal.ArrayComparisonFailure");
        fieldOfObjectToString = object -> object.getClass().getSimpleName() + "." + object.toString();
        isFieldOfClass = object -> {
            try {
                return null != object.getClass().getField(object.toString());
            }
            catch (NoSuchFieldException e) {
                return false;
            }
        };
        isPrimitiveArray = obj -> Character.isLowerCase(obj.getClass().getSimpleName().toCharArray()[0]);
        isFail = ctInvocation -> ctInvocation.getExecutable().getSimpleName().startsWith("fail") || Util.isAssertionClass(ctInvocation.getExecutable().getDeclaringType().getDeclaration());
        isAssert = ctInvocation -> ctInvocation.getExecutable().getSimpleName().startsWith("assert") || Util.isAssertionClass(ctInvocation.getExecutable().getDeclaringType().getDeclaration());
        PATH_SEPARATOR = System.getProperty("path.separator");
        LINE_SEPARATOR = System.getProperty("line.separator");
        FILE_SEPARATOR = System.getProperty("file.separator");
    }
}

