/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async;

import eu.toolchain.async.AsyncCaller;
import eu.toolchain.async.AsyncFramework;
import eu.toolchain.async.AsyncFuture;
import eu.toolchain.async.FutureCancelled;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.FutureFinished;
import eu.toolchain.async.LazyTransform;
import eu.toolchain.async.Transform;
import java.beans.ConstructorProperties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;

public class CancelledFuture<T>
implements AsyncFuture<T> {
    private final AsyncFramework async;
    private final AsyncCaller caller;

    public boolean fail(Throwable error) {
        return false;
    }

    public boolean cancel() {
        return false;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public AsyncFuture<T> on(FutureDone<T> handle) {
        return this;
    }

    public AsyncFuture<T> onAny(FutureDone<?> handle) {
        return this.on(handle);
    }

    public AsyncFuture<T> on(FutureFinished finishable) {
        this.caller.runFutureFinished(finishable);
        return this;
    }

    public AsyncFuture<T> on(FutureCancelled cancelled) {
        this.caller.runFutureCancelled(cancelled);
        return this;
    }

    public boolean isDone() {
        return true;
    }

    public boolean isCancelled() {
        return false;
    }

    public T get() {
        throw new CancellationException();
    }

    public T get(long timeout, TimeUnit unit) {
        throw new CancellationException();
    }

    public T getNow() {
        throw new CancellationException();
    }

    public <C> AsyncFuture<C> transform(LazyTransform<T, C> transform) {
        return this.async.cancelled(this.caller);
    }

    public <C> AsyncFuture<C> transform(Transform<T, C> transform) {
        return this.async.cancelled(this.caller);
    }

    public AsyncFuture<T> error(Transform<Throwable, T> transform) {
        return this;
    }

    public AsyncFuture<T> error(LazyTransform<Throwable, T> transform) {
        return this;
    }

    public AsyncFuture<T> cancelled(Transform<Void, T> transform) {
        Object result;
        try {
            result = transform.transform(null);
        }
        catch (Exception e) {
            return this.async.failed((Throwable)e, this.caller);
        }
        return this.async.resolved(result, this.caller);
    }

    public AsyncFuture<T> cancelled(LazyTransform<Void, T> transform) {
        return this.async.cancelled((AsyncFuture)this, transform, this.caller);
    }

    @ConstructorProperties(value={"async", "caller"})
    public CancelledFuture(AsyncFramework async, AsyncCaller caller) {
        this.async = async;
        this.caller = caller;
    }
}

