/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async;

import eu.toolchain.async.AsyncCaller;
import eu.toolchain.async.AsyncFramework;
import eu.toolchain.async.AsyncFuture;
import eu.toolchain.async.FutureCancelled;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.FutureFinished;
import eu.toolchain.async.LazyTransform;
import eu.toolchain.async.ResolvableFuture;
import eu.toolchain.async.Transform;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class ConcurrentFuture<T>
implements ResolvableFuture<T>,
FutureDone<T> {
    private static final int MAX_SPINS = 10;
    private AtomicReference<List<CallbackEntry<T>>> callbacks = new AtomicReference(new ArrayList());
    private Sync result = new Sync();
    private final AsyncFramework async;
    private final AsyncCaller caller;

    public ConcurrentFuture(AsyncFramework async, AsyncCaller caller) {
        this.async = async;
        this.caller = caller;
    }

    public void failed(Throwable cause) throws Exception {
        this.fail(cause);
    }

    public void resolved(T result) throws Exception {
        this.resolve(result);
    }

    public void cancelled() throws Exception {
        this.cancel();
    }

    public boolean resolve(T result) {
        if (!this.result.complete(1, result)) {
            return false;
        }
        for (CallbackEntry c : (List)this.callbacks.getAndSet(null)) {
            c.resolved(this.caller, result);
        }
        return true;
    }

    public boolean fail(Throwable cause) {
        if (!this.result.complete(2, cause)) {
            return false;
        }
        for (CallbackEntry c : (List)this.callbacks.getAndSet(null)) {
            c.failed(this.caller, cause);
        }
        return true;
    }

    public boolean cancel() {
        return this.cancel(false);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.result.complete(3, null)) {
            return false;
        }
        for (CallbackEntry c : (List)this.callbacks.getAndSet(null)) {
            c.cancelled(this.caller);
        }
        return true;
    }

    public AsyncFuture<T> on(FutureDone<T> done) {
        if (this.add((byte)0, done)) {
            return this;
        }
        int state = this.result.state();
        Object result = this.result.result();
        if (state == 0) {
            throw new IllegalStateException("result is not available");
        }
        if (state == 1) {
            this.caller.resolveFutureDone(done, result);
            return this;
        }
        if (state == 2) {
            this.caller.failFutureDone(done, (Throwable)result);
            return this;
        }
        throw new IllegalStateException("invalid result state: " + state);
    }

    public AsyncFuture<T> onAny(FutureDone<?> handle) {
        return this.on(handle);
    }

    public AsyncFuture<T> on(FutureCancelled cancelled) {
        if (this.add((byte)2, cancelled)) {
            return this;
        }
        if (this.result.state() == 0) {
            throw new IllegalStateException("result is not available");
        }
        this.caller.runFutureCancelled(cancelled);
        return this;
    }

    public AsyncFuture<T> on(FutureFinished finishable) {
        if (this.add((byte)1, finishable)) {
            return this;
        }
        if (this.result.state() == 0) {
            throw new IllegalStateException("result is not available");
        }
        this.caller.runFutureFinished(finishable);
        return this;
    }

    public boolean isDone() {
        return this.result.state() != 0;
    }

    public boolean isCancelled() {
        return this.result.state() == 3;
    }

    public T get() throws InterruptedException, ExecutionException {
        if (!this.isDone()) {
            this.result.acquire();
        }
        return this.checkState();
    }

    public T getNow() throws ExecutionException {
        return this.checkState();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.result.acquire(unit.toNanos(timeout))) {
            throw new TimeoutException();
        }
        return this.checkState();
    }

    private T checkState() throws ExecutionException, CancellationException {
        int state = this.result.state();
        if (state == 0) {
            throw new IllegalStateException("result is not ready");
        }
        Object result = this.result.result();
        switch (state) {
            case 2: {
                throw new ExecutionException((Throwable)result);
            }
            case 1: {
                return (T)result;
            }
            case 3: {
                throw new CancellationException();
            }
        }
        throw new IllegalStateException("illegal state: " + state);
    }

    public <C> AsyncFuture<C> transform(Transform<T, C> transform) {
        return this.async.transform((AsyncFuture)this, transform);
    }

    public <C> AsyncFuture<C> transform(LazyTransform<T, C> transform) {
        return this.async.transform((AsyncFuture)this, transform, this.caller);
    }

    public AsyncFuture<T> error(Transform<Throwable, T> transform) {
        return this.async.error((AsyncFuture)this, transform);
    }

    public AsyncFuture<T> error(LazyTransform<Throwable, T> transform) {
        return this.async.error((AsyncFuture)this, transform, this.caller);
    }

    public AsyncFuture<T> cancelled(Transform<Void, T> transform) {
        return this.async.cancelled((AsyncFuture)this, transform);
    }

    public AsyncFuture<T> cancelled(LazyTransform<Void, T> transform) {
        return this.async.cancelled((AsyncFuture)this, transform, this.caller);
    }

    private boolean add(byte type, Object callback) {
        ArrayList<CallbackEntry<T>> copy;
        List<CallbackEntry<T>> old;
        if (this.result.state() != 0) {
            return false;
        }
        CallbackEntry entry = new CallbackEntry(type, callback);
        int loops = 0;
        do {
            if (loops++ > 10) {
                Thread.yield();
                loops = 0;
            }
            if ((old = this.callbacks.get()) == null) {
                return false;
            }
            copy = new ArrayList<CallbackEntry<T>>(old);
            copy.add(entry);
        } while (!this.callbacks.compareAndSet(old, copy));
        return true;
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private static final int RUNNING = 0;
        private static final int RESOLVED = 1;
        private static final int FAILED = 2;
        private static final int CANCELLED = 3;
        private static final long serialVersionUID = -5044031197562766649L;
        private Object result;

        private Sync() {
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            return this.getState() != 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int state) {
            this.setState(state);
            return true;
        }

        private boolean complete(int state, Object result) {
            if (this.compareAndSetState(0, state)) {
                this.result = result;
                this.releaseShared(state);
                return true;
            }
            return false;
        }

        public boolean acquire(long nanos) throws InterruptedException {
            if (!this.tryAcquireNanos(-1, nanos)) {
                return false;
            }
            return false;
        }

        public void acquire() throws InterruptedException {
            this.acquireSharedInterruptibly(-1);
        }

        public int state() {
            return this.getState();
        }

        public Object result() {
            return this.result;
        }
    }

    private static class CallbackEntry<T> {
        private static final byte DONE = 0;
        private static final byte FINISHED = 1;
        private static final byte CANCELLED = 2;
        private final byte type;
        private final Object callback;

        private void resolved(AsyncCaller caller, T result) {
            if (this.type == 0) {
                caller.resolveFutureDone((FutureDone)this.callback, result);
                return;
            }
            if (this.type == 1) {
                caller.runFutureFinished((FutureFinished)this.callback);
                return;
            }
            if (this.type == 2) {
                return;
            }
            throw new IllegalStateException("invalid callback type: " + this.type);
        }

        private void failed(AsyncCaller caller, Throwable error) {
            if (this.type == 0) {
                caller.failFutureDone((FutureDone)this.callback, error);
                return;
            }
            if (this.type == 1) {
                caller.runFutureFinished((FutureFinished)this.callback);
                return;
            }
            if (this.type == 2) {
                return;
            }
            throw new IllegalStateException("invalid callback type: " + this.type);
        }

        private void cancelled(AsyncCaller caller) {
            if (this.type == 0) {
                caller.cancelFutureDone((FutureDone)this.callback);
                return;
            }
            if (this.type == 1) {
                caller.runFutureFinished((FutureFinished)this.callback);
                return;
            }
            if (this.type == 2) {
                caller.runFutureCancelled((FutureCancelled)this.callback);
                return;
            }
            throw new IllegalStateException("invalid callback type: " + this.type);
        }

        @ConstructorProperties(value={"type", "callback"})
        public CallbackEntry(byte type, Object callback) {
            this.type = type;
            this.callback = callback;
        }
    }
}

