/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async;

import eu.toolchain.async.AsyncCaller;
import eu.toolchain.async.AsyncFramework;
import eu.toolchain.async.AsyncFuture;
import eu.toolchain.async.FutureCancelled;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.FutureFinished;
import eu.toolchain.async.LazyTransform;
import eu.toolchain.async.Transform;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;

public class ResolvedFuture<T>
implements AsyncFuture<T> {
    private final AsyncFramework async;
    private final AsyncCaller caller;
    private final T value;

    public boolean fail(Throwable error) {
        return false;
    }

    public boolean cancel() {
        return false;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public AsyncFuture<T> on(FutureDone<T> handle) {
        this.caller.resolveFutureDone(handle, this.value);
        return this;
    }

    public AsyncFuture<T> onAny(FutureDone<?> handle) {
        return this.on(handle);
    }

    public AsyncFuture<T> on(FutureFinished finishable) {
        this.caller.runFutureFinished(finishable);
        return this;
    }

    public AsyncFuture<T> on(FutureCancelled cancelled) {
        return this;
    }

    public boolean isDone() {
        return true;
    }

    public boolean isCancelled() {
        return false;
    }

    public T get() {
        return this.value;
    }

    public T get(long timeout, TimeUnit unit) {
        return this.value;
    }

    public T getNow() {
        return this.value;
    }

    public <C> AsyncFuture<C> transform(LazyTransform<T, C> transform) {
        try {
            return transform.transform(this.value);
        }
        catch (Exception e) {
            return this.async.failed((Throwable)e, this.caller);
        }
    }

    public <C> AsyncFuture<C> transform(Transform<T, C> transform) {
        Object result;
        try {
            result = transform.transform(this.value);
        }
        catch (Exception e) {
            return this.async.failed((Throwable)e, this.caller);
        }
        return this.async.resolved(result, this.caller);
    }

    public AsyncFuture<T> error(Transform<Throwable, T> transform) {
        return this;
    }

    public AsyncFuture<T> error(LazyTransform<Throwable, T> transform) {
        return this;
    }

    public AsyncFuture<T> cancelled(Transform<Void, T> transform) {
        return this;
    }

    public AsyncFuture<T> cancelled(LazyTransform<Void, T> transform) {
        return this;
    }

    @ConstructorProperties(value={"async", "caller", "value"})
    public ResolvedFuture(AsyncFramework async, AsyncCaller caller, T value) {
        this.async = async;
        this.caller = caller;
        this.value = value;
    }
}

