/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async;

import eu.toolchain.async.AsyncCaller;
import eu.toolchain.async.AsyncFramework;
import eu.toolchain.async.AsyncFuture;
import eu.toolchain.async.CancelledFuture;
import eu.toolchain.async.Collector;
import eu.toolchain.async.Collectors;
import eu.toolchain.async.ConcurrentFuture;
import eu.toolchain.async.FailedFuture;
import eu.toolchain.async.FutureCancelled;
import eu.toolchain.async.LazyTransform;
import eu.toolchain.async.ResolvableFuture;
import eu.toolchain.async.ResolvedFuture;
import eu.toolchain.async.StreamCollector;
import eu.toolchain.async.Transform;
import eu.toolchain.async.caller.DefaultAsyncCaller;
import eu.toolchain.async.caller.ExecutorAsyncCaller;
import eu.toolchain.async.collector.FutureCollector;
import eu.toolchain.async.collector.FutureDiscardCollector;
import eu.toolchain.async.collector.FutureStreamCollector;
import eu.toolchain.async.proxies.LazyTransformCancelledFuture;
import eu.toolchain.async.proxies.LazyTransformErrorFuture;
import eu.toolchain.async.proxies.LazyTransformFuture;
import eu.toolchain.async.proxies.TransformCancelledFutureProxy;
import eu.toolchain.async.proxies.TransformErrorFutureProxy;
import eu.toolchain.async.proxies.TransformFutureProxy;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public final class TinyAsync
implements AsyncFramework {
    private static final Collection<Object> EMPTY_RESULTS = Collections.EMPTY_LIST;
    private final ExecutorService callerExecutor;
    private final ExecutorService defaultExecutor;
    private final AsyncCaller caller;

    private TinyAsync(ExecutorService callerExecutor, ExecutorService defaultExecutor, AsyncCaller caller) {
        this.callerExecutor = callerExecutor;
        this.defaultExecutor = defaultExecutor;
        this.caller = caller;
    }

    public ExecutorService defaultExecutor() {
        if (this.defaultExecutor == null) {
            throw new IllegalStateException("no default executor configured");
        }
        return this.defaultExecutor;
    }

    public ExecutorService callerExecutor() {
        if (this.callerExecutor == null) {
            throw new IllegalStateException("no default executor configured");
        }
        return this.callerExecutor;
    }

    public AsyncCaller threadedCaller() {
        if (this.caller.isThreaded()) {
            return this.caller;
        }
        return new ExecutorAsyncCaller(this.callerExecutor(), this.caller);
    }

    public AsyncCaller caller() {
        return this.caller;
    }

    public <C, T> AsyncFuture<T> transform(AsyncFuture<C> future, Transform<C, T> transform) {
        return new TransformFutureProxy<C, T>(this, future, transform);
    }

    public <C, T> AsyncFuture<T> transform(AsyncFuture<C> future, LazyTransform<C, T> transform) {
        return this.transform(future, transform, this.caller());
    }

    public <C, T> AsyncFuture<T> transform(AsyncFuture<C> future, LazyTransform<C, T> transform, AsyncCaller caller) {
        ResolvableFuture<T> target = this.future();
        future.on(new LazyTransformFuture<C, T>(transform, target));
        return target;
    }

    public <T> AsyncFuture<T> error(AsyncFuture<T> future, Transform<Throwable, T> transform) {
        return new TransformErrorFutureProxy<T>(this, future, transform);
    }

    public <T> AsyncFuture<T> error(AsyncFuture<T> future, LazyTransform<Throwable, T> transform) {
        return this.error(future, transform, this.caller);
    }

    public <T> AsyncFuture<T> error(AsyncFuture<T> future, LazyTransform<Throwable, T> transform, AsyncCaller caller) {
        ResolvableFuture<T> target = this.future(caller);
        future.on(new LazyTransformErrorFuture<T>(transform, target));
        return target;
    }

    public <T> AsyncFuture<T> cancelled(AsyncFuture<T> future, Transform<Void, T> transform) {
        return new TransformCancelledFutureProxy<T>(this, future, transform);
    }

    public <T> AsyncFuture<T> cancelled(AsyncFuture<T> future, LazyTransform<Void, T> transform) {
        return this.cancelled(future, transform, this.caller());
    }

    public <T> AsyncFuture<T> cancelled(AsyncFuture<T> future, LazyTransform<Void, T> transform, AsyncCaller caller) {
        ResolvableFuture<T> target = this.future(caller);
        future.on(new LazyTransformCancelledFuture<T>(transform, target));
        return target;
    }

    public <C> AsyncFuture<C> call(Callable<C> callable) {
        return this.call(callable, this.defaultExecutor(), this.future());
    }

    public <C> AsyncFuture<C> call(Callable<C> callable, ExecutorService executor) {
        return this.call(callable, executor, this.future());
    }

    public <C> AsyncFuture<C> call(final Callable<C> callable, ExecutorService executor, final ResolvableFuture<C> future) {
        Future<?> task;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object result;
                if (future.isDone()) {
                    return;
                }
                try {
                    result = callable.call();
                }
                catch (Exception error) {
                    future.fail((Throwable)error);
                    return;
                }
                future.resolve(result);
            }
        };
        try {
            task = executor.submit(runnable);
        }
        catch (Exception e) {
            future.fail((Throwable)e);
            return future;
        }
        future.on(new FutureCancelled(){

            public void cancelled() throws Exception {
                task.cancel(false);
            }
        });
        return future;
    }

    public <T> ResolvableFuture<T> future() {
        return this.future(this.caller());
    }

    public <T> ResolvableFuture<T> future(AsyncCaller caller) {
        return new ConcurrentFuture(this, caller);
    }

    public <T> AsyncFuture<T> resolved(T value) {
        return this.resolved(value, this.caller());
    }

    public <T> AsyncFuture<T> resolved(T value, AsyncCaller caller) {
        return new ResolvedFuture<T>(this, caller, value);
    }

    public <T> AsyncFuture<T> failed(Throwable e) {
        return this.failed(e, this.caller);
    }

    public <T> AsyncFuture<T> failed(Throwable e, AsyncCaller caller) {
        return new FailedFuture(this, caller, e);
    }

    public <T> AsyncFuture<T> cancelled() {
        return this.cancelled(this.caller());
    }

    public <T> AsyncFuture<T> cancelled(AsyncCaller caller) {
        return new CancelledFuture(this, caller);
    }

    public <T> AsyncFuture<Collection<T>> collect(Collection<AsyncFuture<T>> futures) {
        if (futures.isEmpty()) {
            return this.resolved(EMPTY_RESULTS);
        }
        ResolvableFuture<T> target = this.future();
        FutureCollector done = new FutureCollector(futures.size(), Collectors.collection(), target);
        for (AsyncFuture<T> q : futures) {
            q.on(done);
        }
        return target;
    }

    public <C, T> AsyncFuture<T> collect(Collection<AsyncFuture<C>> futures, Collector<C, T> collector) {
        if (futures.isEmpty()) {
            return this.collectEmpty(collector);
        }
        ResolvableFuture<T> target = this.future();
        FutureCollector<C, T> done = new FutureCollector<C, T>(futures.size(), collector, target);
        for (AsyncFuture<C> q : futures) {
            q.on(done);
        }
        return target;
    }

    private <C, T> AsyncFuture<T> collectEmpty(Collector<C, T> collector) {
        try {
            return this.resolved(collector.collect(EMPTY_RESULTS));
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    public <C, T> AsyncFuture<T> collect(Collection<AsyncFuture<C>> futures, StreamCollector<C, T> collector) {
        return this.collect(futures, collector, this.caller());
    }

    public <C, T> AsyncFuture<T> collect(Collection<AsyncFuture<C>> futures, StreamCollector<C, T> collector, AsyncCaller caller) {
        if (futures.isEmpty()) {
            return this.collectEmpty(collector);
        }
        ResolvableFuture<T> target = this.future();
        FutureStreamCollector<C, T> done = new FutureStreamCollector<C, T>(caller, futures.size(), collector, target);
        for (AsyncFuture<C> q : futures) {
            q.on(done);
        }
        return target;
    }

    private <C, T> AsyncFuture<T> collectEmpty(StreamCollector<C, T> collector) {
        try {
            return this.resolved(collector.end(0, 0, 0));
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    public <C> AsyncFuture<Void> collectAndDiscard(Collection<AsyncFuture<C>> futures) {
        if (futures.isEmpty()) {
            return this.resolved(null);
        }
        ResolvableFuture target = this.future();
        FutureDiscardCollector done = new FutureDiscardCollector(futures.size(), target);
        for (AsyncFuture<C> q : futures) {
            q.on(done);
        }
        return target;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AsyncCaller caller = new DefaultAsyncCaller();
        private boolean threaded = false;
        private ExecutorService defaultExecutor = null;
        private ExecutorService callerExecutor = null;

        private Builder() {
        }

        public Builder threaded(boolean threaded) {
            this.threaded = threaded;
            return this;
        }

        public Builder caller(AsyncCaller caller) {
            if (caller == null) {
                throw new IllegalArgumentException("caller");
            }
            this.caller = caller;
            return this;
        }

        public Builder executor(ExecutorService defaultExecutor) {
            if (defaultExecutor == null) {
                throw new IllegalArgumentException("defaultExecutor");
            }
            this.defaultExecutor = defaultExecutor;
            return this;
        }

        public Builder callerExecutor(ExecutorService callerExecutor) {
            if (callerExecutor == null) {
                throw new IllegalArgumentException("callerExecutor");
            }
            this.callerExecutor = callerExecutor;
            return this;
        }

        public TinyAsync build() {
            ExecutorService defaultExecutor = this.setupDefaultExecutor();
            ExecutorService callerExecutor = this.setupCallerExecutor(defaultExecutor);
            AsyncCaller caller = this.setupCaller(callerExecutor);
            return new TinyAsync(callerExecutor, defaultExecutor, caller);
        }

        private ExecutorService setupDefaultExecutor() {
            if (this.defaultExecutor != null) {
                return this.defaultExecutor;
            }
            if (this.threaded) {
                throw new IllegalStateException("no primary executor service available, set one using either #executor(ExecutorService))");
            }
            return null;
        }

        private ExecutorService setupCallerExecutor(ExecutorService defaultExecutor) {
            if (this.callerExecutor != null) {
                return this.callerExecutor;
            }
            if (defaultExecutor != null) {
                return defaultExecutor;
            }
            if (this.threaded) {
                throw new IllegalStateException("no executor service available for caller, set one using either #executor(ExecutorService) or #callerExecutor(ExecutorService)");
            }
            return null;
        }

        private AsyncCaller setupCaller(ExecutorService callerExecutor) {
            if (this.threaded && callerExecutor == null) {
                throw new IllegalStateException("no executor service available for caller, set one using either #executor(ExecutorService) or #callerExecutor(ExecutorService)");
            }
            if (this.caller == null) {
                throw new IllegalStateException("caller: must be configured");
            }
            if (this.threaded) {
                if (this.caller.isThreaded()) {
                    return this.caller;
                }
                return new ExecutorAsyncCaller(callerExecutor, this.caller);
            }
            return this.caller;
        }
    }
}

