/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async.collector;

import eu.toolchain.async.Collector;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.ResolvableFuture;
import eu.toolchain.async.ThrowableUtils;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class FutureCollector<S, T>
implements FutureDone<S> {
    private final int size;
    private final Collector<S, T> reducable;
    private final ResolvableFuture<T> target;
    private final AtomicReferenceArray<Entry> results;
    private final AtomicInteger position = new AtomicInteger();

    public FutureCollector(int size, Collector<S, T> reducable, ResolvableFuture<T> target) {
        this.size = size;
        this.reducable = reducable;
        this.target = target;
        this.results = new AtomicReferenceArray(size);
    }

    public void failed(Throwable e) throws Exception {
        this.add(this.position.getAndIncrement(), new Entry(1, e));
    }

    public void resolved(S result) throws Exception {
        this.add(this.position.getAndIncrement(), new Entry(0, result));
    }

    public void cancelled() throws Exception {
        this.add(this.position.getAndIncrement(), new Entry(2, null));
    }

    private void add(int p, Entry entry) {
        if (p >= this.size) {
            throw new IllegalStateException("too many results received, expected " + this.size + " but got " + p);
        }
        this.results.set(p, entry);
        if (p + 1 < this.size) {
            return;
        }
        Results<S> r = this.readResults();
        this.done(((Results)r).results, ((Results)r).errors, ((Results)r).cancelled);
    }

    private void done(Collection<S> results, Collection<Throwable> errors, int cancelled) {
        Object result;
        if (!errors.isEmpty()) {
            this.target.fail(ThrowableUtils.buildCollectedException(errors));
            return;
        }
        if (cancelled > 0) {
            this.target.cancel();
            return;
        }
        try {
            result = this.reducable.collect(results);
        }
        catch (Exception error) {
            this.target.fail((Throwable)error);
            return;
        }
        this.target.resolve(result);
    }

    private Results<S> readResults() {
        ArrayList<Object> results = new ArrayList<Object>();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        int cancelled = 0;
        block5: for (int i = 0; i < this.size; ++i) {
            Entry e = this.results.get(i);
            switch (e.type) {
                case 1: {
                    errors.add((Throwable)e.value);
                    continue block5;
                }
                case 0: {
                    results.add(e.value);
                    continue block5;
                }
                case 2: {
                    ++cancelled;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid entry type: " + e.type);
                }
            }
        }
        return new Results(results, errors, cancelled);
    }

    private static class Results<T> {
        private final List<T> results;
        private final List<Throwable> errors;
        private final int cancelled;

        @ConstructorProperties(value={"results", "errors", "cancelled"})
        public Results(List<T> results, List<Throwable> errors, int cancelled) {
            this.results = results;
            this.errors = errors;
            this.cancelled = cancelled;
        }
    }

    private static final class Entry {
        private static final byte RESULT = 0;
        private static final byte ERROR = 1;
        private static final byte CANCEL = 2;
        private final byte type;
        private final Object value;

        @ConstructorProperties(value={"type", "value"})
        public Entry(byte type, Object value) {
            this.type = type;
            this.value = value;
        }
    }
}

