/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async.collector;

import eu.toolchain.async.FutureDone;
import eu.toolchain.async.ResolvableFuture;
import eu.toolchain.async.ThrowableUtils;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class FutureDiscardCollector<S>
implements FutureDone<S> {
    private final ResolvableFuture<Void> target;
    private final AtomicInteger countdown;
    private final AtomicInteger cancelled = new AtomicInteger();
    private final ConcurrentLinkedQueue<Throwable> errors = new ConcurrentLinkedQueue();

    public FutureDiscardCollector(int size, ResolvableFuture<Void> target) {
        this.target = target;
        this.countdown = new AtomicInteger(size);
    }

    public void failed(Throwable e) throws Exception {
        this.errors.add(e);
        this.check();
    }

    public void resolved(S result) throws Exception {
        this.check();
    }

    public void cancelled() throws Exception {
        this.cancelled.incrementAndGet();
        this.check();
    }

    private void done() {
        if (!this.errors.isEmpty()) {
            this.target.fail(ThrowableUtils.buildCollectedException(this.errors));
            return;
        }
        if (this.cancelled.get() > 0) {
            this.target.cancel();
            return;
        }
        this.target.resolve(null);
    }

    private void check() throws Exception {
        if (this.countdown.decrementAndGet() == 0) {
            this.done();
        }
    }
}

