/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async.proxies;

import eu.toolchain.async.AsyncFuture;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.LazyTransform;
import eu.toolchain.async.ResolvableFuture;
import java.beans.ConstructorProperties;

public class LazyTransformFuture<S, T>
implements FutureDone<S> {
    private final LazyTransform<S, T> transform;
    private final ResolvableFuture<T> target;

    public void failed(Throwable e) throws Exception {
        this.target.fail(e);
    }

    public void resolved(S result) throws Exception {
        AsyncFuture t;
        try {
            t = this.transform.transform(result);
        }
        catch (Exception e) {
            this.failed(e);
            return;
        }
        t.on(new FutureDone<T>(){

            public void failed(Throwable e) throws Exception {
                LazyTransformFuture.this.target.fail(e);
            }

            public void resolved(T result) throws Exception {
                LazyTransformFuture.this.target.resolve(result);
            }

            public void cancelled() throws Exception {
                LazyTransformFuture.this.target.cancel();
            }
        });
    }

    public void cancelled() throws Exception {
        this.target.cancel();
    }

    @ConstructorProperties(value={"transform", "target"})
    public LazyTransformFuture(LazyTransform<S, T> transform, ResolvableFuture<T> target) {
        this.transform = transform;
        this.target = target;
    }
}

