/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async.proxies;

import eu.toolchain.async.AsyncFuture;
import eu.toolchain.async.FutureCancelled;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.FutureFinished;
import eu.toolchain.async.LazyTransform;
import eu.toolchain.async.TinyAsync;
import eu.toolchain.async.Transform;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TransformErrorFutureProxy<T>
implements AsyncFuture<T> {
    private final TinyAsync async;
    private final AsyncFuture<T> source;
    private final Transform<Throwable, T> transform;

    public boolean cancel() {
        return this.source.cancel();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.source.cancel(mayInterruptIfRunning);
    }

    public boolean fail(Throwable error) {
        return this.source.fail(error);
    }

    public AsyncFuture<T> on(final FutureDone<T> handle) {
        this.source.on(new FutureDone<T>(){

            public void failed(Throwable original) throws Exception {
                try {
                    handle.resolved(TransformErrorFutureProxy.this.transform.transform((Object)original));
                }
                catch (Exception inner) {
                    original.addSuppressed(original);
                    handle.failed((Throwable)inner);
                }
            }

            public void resolved(T result) throws Exception {
                handle.resolved(result);
            }

            public void cancelled() throws Exception {
                handle.cancelled();
            }
        });
        return this;
    }

    public AsyncFuture<T> onAny(FutureDone<?> handle) {
        this.source.onAny(handle);
        return this;
    }

    public AsyncFuture<T> on(FutureFinished finishable) {
        this.source.on(finishable);
        return this;
    }

    public AsyncFuture<T> on(FutureCancelled cancelled) {
        this.source.on(cancelled);
        return this;
    }

    public boolean isDone() {
        return this.source.isDone();
    }

    public boolean isCancelled() {
        return this.source.isCancelled();
    }

    public T get() throws InterruptedException, ExecutionException {
        try {
            return (T)this.source.get();
        }
        catch (ExecutionException e) {
            return this.getHandleException(e);
        }
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (T)this.source.get(timeout, unit);
        }
        catch (ExecutionException e) {
            return this.getHandleException(e);
        }
    }

    public T getNow() throws ExecutionException {
        try {
            return (T)this.source.getNow();
        }
        catch (ExecutionException e) {
            return this.getHandleException(e);
        }
    }

    private T getHandleException(ExecutionException original) throws ExecutionException {
        try {
            return (T)this.transform.transform((Object)original);
        }
        catch (Exception inner) {
            inner.addSuppressed(original);
            throw new ExecutionException(inner);
        }
    }

    public <C> AsyncFuture<C> transform(Transform<T, C> transform) {
        return this.async.transform(this, transform);
    }

    public <C> AsyncFuture<C> transform(LazyTransform<T, C> transform) {
        return this.async.transform(this, transform);
    }

    public AsyncFuture<T> error(Transform<Throwable, T> transform) {
        return this.async.error(this, transform);
    }

    public AsyncFuture<T> error(LazyTransform<Throwable, T> transform) {
        return this.async.error(this, transform);
    }

    public AsyncFuture<T> cancelled(Transform<Void, T> transform) {
        return this.async.cancelled(this, transform);
    }

    public AsyncFuture<T> cancelled(LazyTransform<Void, T> transform) {
        return this.async.cancelled(this, transform);
    }

    @ConstructorProperties(value={"async", "source", "transform"})
    public TransformErrorFutureProxy(TinyAsync async, AsyncFuture<T> source, Transform<Throwable, T> transform) {
        this.async = async;
        this.source = source;
        this.transform = transform;
    }
}

