/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async.proxies;

import eu.toolchain.async.AsyncFuture;
import eu.toolchain.async.FutureCancelled;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.FutureFinished;
import eu.toolchain.async.LazyTransform;
import eu.toolchain.async.TinyAsync;
import eu.toolchain.async.Transform;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TransformFutureProxy<S, T>
implements AsyncFuture<T> {
    private final TinyAsync async;
    private final AsyncFuture<S> source;
    private final Transform<S, T> transform;

    public boolean cancel() {
        return this.source.cancel();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.source.cancel(mayInterruptIfRunning);
    }

    public boolean fail(Throwable error) {
        return this.source.fail(error);
    }

    public AsyncFuture<T> on(final FutureDone<T> handle) {
        this.source.on(new FutureDone<S>(){

            public void failed(Throwable e) throws Exception {
                handle.failed(e);
            }

            public void resolved(S result) throws Exception {
                try {
                    handle.resolved(TransformFutureProxy.this.transform.transform(result));
                }
                catch (Exception e) {
                    handle.failed((Throwable)e);
                }
            }

            public void cancelled() throws Exception {
                handle.cancelled();
            }
        });
        return this;
    }

    public AsyncFuture<T> onAny(FutureDone<?> handle) {
        this.source.onAny(handle);
        return this;
    }

    public AsyncFuture<T> on(FutureFinished finishable) {
        this.source.on(finishable);
        return this;
    }

    public AsyncFuture<T> on(FutureCancelled cancelled) {
        this.source.on(cancelled);
        return null;
    }

    public boolean isCancelled() {
        return this.source.isCancelled();
    }

    public boolean isDone() {
        return this.source.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        Object result = this.source.get();
        try {
            return (T)this.transform.transform(result);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object result = this.source.get(timeout, unit);
        try {
            return (T)this.transform.transform(result);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public T getNow() throws ExecutionException {
        Object result = this.source.getNow();
        try {
            return (T)this.transform.transform(result);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public <C> AsyncFuture<C> transform(Transform<T, C> transform) {
        return this.async.transform(this, transform);
    }

    public <C> AsyncFuture<C> transform(LazyTransform<T, C> transform) {
        return this.async.transform(this, transform);
    }

    public AsyncFuture<T> error(Transform<Throwable, T> transform) {
        return this.async.error(this, transform);
    }

    public AsyncFuture<T> error(LazyTransform<Throwable, T> transform) {
        return this.async.error(this, transform);
    }

    public AsyncFuture<T> cancelled(Transform<Void, T> transform) {
        return this.async.cancelled(this, transform);
    }

    public AsyncFuture<T> cancelled(LazyTransform<Void, T> transform) {
        return this.async.cancelled(this, transform);
    }

    @ConstructorProperties(value={"async", "source", "transform"})
    public TransformFutureProxy(TinyAsync async, AsyncFuture<S> source, Transform<S, T> transform) {
        this.async = async;
        this.source = source;
        this.transform = transform;
    }
}

