/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async;

import eu.toolchain.async.Collector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Collectors {
    private static final Collector<?, ? extends List<?>> LIST = new Collector<Object, List<Object>>(){

        public List<Object> collect(Collection<Object> results) throws Exception {
            return new ArrayList<Object>(results);
        }
    };
    private static final Collector<? extends Set<?>, ? extends Set<?>> JOIN_SETS = new Collector<Set<Object>, Set<Object>>(){

        public Set<Object> collect(Collection<Set<Object>> results) throws Exception {
            HashSet<Object> all = new HashSet<Object>();
            for (Set<Object> result : results) {
                all.addAll(result);
            }
            return all;
        }
    };
    private static final Collector<? extends List<?>, ? extends List<?>> JOIN_LISTS = new Collector<List<Object>, List<Object>>(){

        public List<Object> collect(Collection<List<Object>> results) throws Exception {
            ArrayList<Object> list = new ArrayList<Object>();
            for (List<Object> part : results) {
                list.addAll(part);
            }
            return list;
        }
    };
    private static final Collector<?, ? extends Collection<?>> COLLECTION = new Collector<Object, Collection<Object>>(){

        public Collection<Object> collect(Collection<Object> results) throws Exception {
            return results;
        }
    };

    public static <T> Collector<T, List<T>> list() {
        return LIST;
    }

    public static <T> Collector<Set<T>, Set<T>> joinSets() {
        return JOIN_SETS;
    }

    public static <T> Collector<List<T>, List<T>> joinLists() {
        return JOIN_LISTS;
    }

    public static <T> Collector<T, Collection<T>> collection() {
        return COLLECTION;
    }
}

