/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async;

import eu.toolchain.async.AsyncCaller;
import eu.toolchain.async.AsyncFramework;
import eu.toolchain.async.AsyncFuture;
import eu.toolchain.async.FutureCancelled;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.FutureFailed;
import eu.toolchain.async.FutureFinished;
import eu.toolchain.async.FutureResolved;
import eu.toolchain.async.LazyTransform;
import eu.toolchain.async.ResolvableFuture;
import eu.toolchain.async.Transform;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class ConcurrentFuture<T>
implements ResolvableFuture<T> {
    private static final int MAX_SPINS = 10;
    private final Object $lock = new Object();
    private Sync sync = new Sync();
    private volatile ArrayList<CB<T>> callbacks = new ArrayList();
    private final AsyncFramework async;
    private final AsyncCaller caller;

    public ConcurrentFuture(AsyncFramework async, AsyncCaller caller) {
        this.async = async;
        this.caller = caller;
    }

    public boolean resolve(T result) {
        if (!this.sync.complete(16, result)) {
            return false;
        }
        ArrayList<CB<T>> entries = this.takeAndClear();
        for (CB<T> c : entries) {
            c.resolved(result);
        }
        return true;
    }

    public boolean fail(Throwable cause) {
        if (!this.sync.complete(17, cause)) {
            return false;
        }
        ArrayList<CB<T>> entries = this.takeAndClear();
        for (CB<T> c : entries) {
            c.failed(cause);
        }
        return true;
    }

    public boolean cancel() {
        return this.cancel(false);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.sync.complete(18, null)) {
            return false;
        }
        ArrayList<CB<T>> entries = this.takeAndClear();
        for (CB<T> c : entries) {
            c.cancelled();
        }
        return true;
    }

    public AsyncFuture<T> bind(AsyncFuture<?> other) {
        int state = this.sync.state();
        if (!Sync.isReady(state)) {
            if (this.add(new AsyncFutureCB(other))) {
                return this;
            }
            state = this.sync.poll();
        }
        if (state == 18) {
            other.cancel();
        }
        return this;
    }

    public AsyncFuture<T> on(FutureDone<? super T> done) {
        int state = this.sync.state();
        if (!Sync.isReady(state)) {
            if (this.add(new DoneCB(done))) {
                return this;
            }
            state = this.sync.poll();
        }
        if (state == 16) {
            this.caller.resolveFutureDone(done, this.sync.result);
            return this;
        }
        if (state == 17) {
            this.caller.failFutureDone(done, (Throwable)this.sync.result);
            return this;
        }
        if (state == 18) {
            this.caller.cancelFutureDone(done);
            return this;
        }
        throw new IllegalStateException("invalid result state: " + state);
    }

    public AsyncFuture<T> onAny(FutureDone<?> handle) {
        return this.on(handle);
    }

    public AsyncFuture<T> on(FutureCancelled cancelled) {
        int state = this.sync.state();
        if (!Sync.isReady(state)) {
            if (this.add(new CancelledCB(cancelled))) {
                return this;
            }
            state = this.sync.poll();
        }
        if (state == 18) {
            this.caller.runFutureCancelled(cancelled);
        }
        return this;
    }

    public AsyncFuture<T> on(FutureFinished finishable) {
        int state = this.sync.state();
        if (!Sync.isReady(state) && this.add(new FinishedCB(finishable))) {
            return this;
        }
        this.caller.runFutureFinished(finishable);
        return this;
    }

    public AsyncFuture<T> on(FutureResolved<? super T> resolved) {
        int state = this.sync.state();
        if (!Sync.isReady(state)) {
            if (this.add(new ResolvedCB(resolved))) {
                return this;
            }
            state = this.sync.poll();
        }
        if (state == 16) {
            this.caller.runFutureResolved(resolved, this.sync.result);
        }
        return this;
    }

    public AsyncFuture<T> on(FutureFailed failed) {
        int state = this.sync.state();
        if (!Sync.isReady(state)) {
            if (this.add(new FailedCB(failed))) {
                return this;
            }
            state = this.sync.poll();
        }
        if (state == 17) {
            this.caller.runFutureFailed(failed, (Throwable)this.sync.result);
        }
        return this;
    }

    public boolean isDone() {
        return Sync.isReady(this.sync.state());
    }

    public boolean isCancelled() {
        return Sync.isCancelled(this.sync.state());
    }

    public T get() throws InterruptedException, ExecutionException {
        int state = this.sync.state();
        if (Sync.isReady(state)) {
            return this.checkState(state);
        }
        this.sync.acquire();
        return this.checkState(this.sync.state());
    }

    public T getNow() throws ExecutionException {
        int state = this.sync.state();
        if (!Sync.isReady(state)) {
            throw new IllegalStateException("sync state is not ready");
        }
        return this.checkState(state);
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        int state = this.sync.state();
        if (Sync.isReady(state)) {
            return this.checkState(state);
        }
        if (!this.sync.acquire(unit.toNanos(timeout))) {
            throw new TimeoutException();
        }
        return this.checkState(this.sync.poll());
    }

    private T checkState(int state) throws ExecutionException, CancellationException {
        switch (state) {
            case 17: {
                throw new ExecutionException((Throwable)this.sync.result);
            }
            case 16: {
                return (T)this.sync.result;
            }
            case 18: {
                throw new CancellationException();
            }
        }
        throw new IllegalStateException("illegal state: " + state);
    }

    public <C> AsyncFuture<C> transform(Transform<? super T, ? extends C> transform) {
        return this.async.transform((AsyncFuture)this, transform);
    }

    public <C> AsyncFuture<C> transform(LazyTransform<? super T, ? extends C> transform) {
        return this.async.transform((AsyncFuture)this, transform, this.caller);
    }

    public AsyncFuture<T> error(Transform<Throwable, ? extends T> transform) {
        return this.async.error((AsyncFuture)this, transform);
    }

    public AsyncFuture<T> error(LazyTransform<Throwable, ? extends T> transform) {
        return this.async.error((AsyncFuture)this, transform, this.caller);
    }

    public AsyncFuture<T> cancelled(Transform<Void, ? extends T> transform) {
        return this.async.cancelled((AsyncFuture)this, transform);
    }

    public AsyncFuture<T> cancelled(LazyTransform<Void, ? extends T> transform) {
        return this.async.cancelled((AsyncFuture)this, transform, this.caller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<CB<T>> takeAndClear() {
        ArrayList<CB<T>> entries;
        Object object = this.$lock;
        synchronized (object) {
            entries = this.callbacks;
            this.callbacks = null;
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(CB<T> entry) {
        Object object = this.$lock;
        synchronized (object) {
            if (this.callbacks == null) {
                return false;
            }
            this.callbacks.add(entry);
        }
        return true;
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private static final int RUNNING = 0;
        private static final int RESULT_UPDATING = 1;
        private static final int RESOLVED = 16;
        private static final int FAILED = 17;
        private static final int CANCELLED = 18;
        private static final long serialVersionUID = -5044031197562766649L;
        private Object result;

        private Sync() {
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            return this.getState() >= 16 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int state) {
            this.setState(state);
            return true;
        }

        private boolean complete(int state, Object result) {
            if (result == null) {
                if (!this.compareAndSetState(0, state)) {
                    return false;
                }
                this.releaseShared(state);
                return true;
            }
            if (!this.compareAndSetState(0, 1)) {
                return false;
            }
            this.result = result;
            this.releaseShared(state);
            return true;
        }

        public boolean acquire(long nanos) throws InterruptedException {
            return this.tryAcquireSharedNanos(-1, nanos);
        }

        public void acquire() throws InterruptedException {
            this.acquireSharedInterruptibly(-1);
        }

        public int state() {
            return this.getState();
        }

        public int poll() {
            int s;
            int spins = 0;
            while ((s = this.getState()) == 1) {
                if (spins++ <= 10) continue;
                Thread.yield();
                spins = 0;
            }
            return s;
        }

        public static boolean isReady(int state) {
            return state > 1;
        }

        public static boolean isCancelled(int state) {
            return state == 18;
        }
    }

    private class CancelledCB
    implements CB<T> {
        private final FutureCancelled callback;

        @Override
        public void resolved(T result) {
        }

        @Override
        public void failed(Throwable error) {
        }

        @Override
        public void cancelled() {
            ConcurrentFuture.this.caller.runFutureCancelled(this.callback);
        }

        @ConstructorProperties(value={"callback"})
        public CancelledCB(FutureCancelled callback) {
            this.callback = callback;
        }
    }

    private class FinishedCB
    implements CB<T> {
        private final FutureFinished callback;

        @Override
        public void resolved(T result) {
            ConcurrentFuture.this.caller.runFutureFinished(this.callback);
        }

        @Override
        public void failed(Throwable error) {
            ConcurrentFuture.this.caller.runFutureFinished(this.callback);
        }

        @Override
        public void cancelled() {
            ConcurrentFuture.this.caller.runFutureFinished(this.callback);
        }

        @ConstructorProperties(value={"callback"})
        public FinishedCB(FutureFinished callback) {
            this.callback = callback;
        }
    }

    private class ResolvedCB
    implements CB<T> {
        private final FutureResolved<? super T> callback;

        @Override
        public void resolved(T result) {
            ConcurrentFuture.this.caller.runFutureResolved(this.callback, result);
        }

        @Override
        public void failed(Throwable error) {
        }

        @Override
        public void cancelled() {
        }

        @ConstructorProperties(value={"callback"})
        public ResolvedCB(FutureResolved<? super T> callback) {
            this.callback = callback;
        }
    }

    private class FailedCB
    implements CB<T> {
        private final FutureFailed callback;

        @Override
        public void resolved(T result) {
        }

        @Override
        public void failed(Throwable cause) {
            ConcurrentFuture.this.caller.runFutureFailed(this.callback, cause);
        }

        @Override
        public void cancelled() {
        }

        @ConstructorProperties(value={"callback"})
        public FailedCB(FutureFailed callback) {
            this.callback = callback;
        }
    }

    private class DoneCB
    implements CB<T> {
        private final FutureDone<? super T> callback;

        @Override
        public void resolved(T result) {
            ConcurrentFuture.this.caller.resolveFutureDone(this.callback, result);
        }

        @Override
        public void failed(Throwable error) {
            ConcurrentFuture.this.caller.failFutureDone(this.callback, error);
        }

        @Override
        public void cancelled() {
            ConcurrentFuture.this.caller.cancelFutureDone(this.callback);
        }

        @ConstructorProperties(value={"callback"})
        public DoneCB(FutureDone<? super T> callback) {
            this.callback = callback;
        }
    }

    private class AsyncFutureCB
    implements CB<T> {
        private final AsyncFuture<?> other;

        @Override
        public void resolved(T result) {
        }

        @Override
        public void failed(Throwable cause) {
        }

        @Override
        public void cancelled() {
            this.other.cancel();
        }

        @ConstructorProperties(value={"other"})
        public AsyncFutureCB(AsyncFuture<?> other) {
            this.other = other;
        }
    }

    private static interface CB<T> {
        public void resolved(T var1);

        public void failed(Throwable var1);

        public void cancelled();
    }
}

