/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async;

import eu.toolchain.async.AsyncCaller;
import eu.toolchain.async.AsyncFramework;
import eu.toolchain.async.AsyncFuture;
import eu.toolchain.async.FutureCancelled;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.FutureFailed;
import eu.toolchain.async.FutureFinished;
import eu.toolchain.async.FutureResolved;
import eu.toolchain.async.LazyTransform;
import eu.toolchain.async.Transform;
import eu.toolchain.async.TransformException;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class FailedFuture<T>
implements AsyncFuture<T> {
    private final AsyncFramework async;
    private final AsyncCaller caller;
    private final Throwable cause;

    public boolean fail(Throwable cause) {
        return false;
    }

    public boolean cancel() {
        return false;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public AsyncFuture<T> bind(AsyncFuture<?> other) {
        return this;
    }

    public AsyncFuture<T> on(FutureDone<? super T> handle) {
        this.caller.failFutureDone(handle, this.cause);
        return this;
    }

    public AsyncFuture<T> onAny(FutureDone<?> handle) {
        return this.on(handle);
    }

    public AsyncFuture<T> on(FutureFinished finishable) {
        this.caller.runFutureFinished(finishable);
        return this;
    }

    public AsyncFuture<T> on(FutureCancelled cancelled) {
        return this;
    }

    public AsyncFuture<T> on(FutureResolved<? super T> resolved) {
        return this;
    }

    public AsyncFuture<T> on(FutureFailed failed) {
        this.caller.runFutureFailed(failed, this.cause);
        return this;
    }

    public boolean isDone() {
        return true;
    }

    public boolean isCancelled() {
        return false;
    }

    public T get() throws ExecutionException {
        throw new ExecutionException(this.cause);
    }

    public T get(long timeout, TimeUnit unit) throws ExecutionException {
        throw new ExecutionException(this.cause);
    }

    public T getNow() throws ExecutionException {
        throw new ExecutionException(this.cause);
    }

    public <C> AsyncFuture<C> transform(LazyTransform<? super T, ? extends C> transform) {
        return this.async.failed(this.cause, this.caller);
    }

    public <C> AsyncFuture<C> transform(Transform<? super T, ? extends C> transform) {
        return this.async.failed(this.cause, this.caller);
    }

    public AsyncFuture<T> error(Transform<Throwable, ? extends T> transform) {
        Object result;
        try {
            result = transform.transform((Object)this.cause);
        }
        catch (Exception e) {
            TransformException inner = new TransformException(e);
            e.addSuppressed(this.cause);
            return this.async.failed((Throwable)inner, this.caller);
        }
        return this.async.resolved(result, this.caller);
    }

    public AsyncFuture<T> error(LazyTransform<Throwable, ? extends T> transform) {
        return this.async.error((AsyncFuture)this, transform);
    }

    public AsyncFuture<T> cancelled(Transform<Void, ? extends T> transform) {
        return this;
    }

    public AsyncFuture<T> cancelled(LazyTransform<Void, ? extends T> transform) {
        return this;
    }

    @ConstructorProperties(value={"async", "caller", "cause"})
    public FailedFuture(AsyncFramework async, AsyncCaller caller, Throwable cause) {
        this.async = async;
        this.caller = caller;
        this.cause = cause;
    }
}

