/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async;

import eu.toolchain.async.AsyncCaller;
import eu.toolchain.async.AsyncFramework;
import eu.toolchain.async.AsyncFuture;
import eu.toolchain.async.FutureCancelled;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.FutureFailed;
import eu.toolchain.async.FutureFinished;
import eu.toolchain.async.FutureResolved;
import eu.toolchain.async.LazyTransform;
import eu.toolchain.async.Transform;
import java.beans.ConstructorProperties;
import java.util.concurrent.TimeUnit;

public class ResolvedFuture<T>
implements AsyncFuture<T> {
    private final AsyncFramework async;
    private final AsyncCaller caller;
    private final T result;

    public boolean fail(Throwable cause) {
        return false;
    }

    public boolean cancel() {
        return false;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public AsyncFuture<T> bind(AsyncFuture<?> other) {
        return this;
    }

    public AsyncFuture<T> on(FutureDone<? super T> handle) {
        this.caller.resolveFutureDone(handle, this.result);
        return this;
    }

    public AsyncFuture<T> onAny(FutureDone<?> handle) {
        return this.on(handle);
    }

    public AsyncFuture<T> on(FutureFinished finishable) {
        this.caller.runFutureFinished(finishable);
        return this;
    }

    public AsyncFuture<T> on(FutureCancelled cancelled) {
        return this;
    }

    public AsyncFuture<T> on(FutureResolved<? super T> resolved) {
        this.caller.runFutureResolved(resolved, this.result);
        return this;
    }

    public AsyncFuture<T> on(FutureFailed failed) {
        return this;
    }

    public boolean isDone() {
        return true;
    }

    public boolean isCancelled() {
        return false;
    }

    public T get() {
        return this.result;
    }

    public T get(long timeout, TimeUnit unit) {
        return this.result;
    }

    public T getNow() {
        return this.result;
    }

    public <C> AsyncFuture<C> transform(LazyTransform<? super T, ? extends C> transform) {
        try {
            return transform.transform(this.result);
        }
        catch (Exception e) {
            return this.async.failed((Throwable)e, this.caller);
        }
    }

    public <C> AsyncFuture<C> transform(Transform<? super T, ? extends C> transform) {
        Object value;
        try {
            value = transform.transform(this.result);
        }
        catch (Exception e) {
            return this.async.failed((Throwable)e, this.caller);
        }
        return this.async.resolved(value, this.caller);
    }

    public AsyncFuture<T> error(Transform<Throwable, ? extends T> transform) {
        return this;
    }

    public AsyncFuture<T> error(LazyTransform<Throwable, ? extends T> transform) {
        return this;
    }

    public AsyncFuture<T> cancelled(Transform<Void, ? extends T> transform) {
        return this;
    }

    public AsyncFuture<T> cancelled(LazyTransform<Void, ? extends T> transform) {
        return this;
    }

    @ConstructorProperties(value={"async", "caller", "result"})
    public ResolvedFuture(AsyncFramework async, AsyncCaller caller, T result) {
        this.async = async;
        this.caller = caller;
        this.result = result;
    }
}

