/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async.collector;

import eu.toolchain.async.Collector;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.ResolvableFuture;
import eu.toolchain.async.ThrowableUtils;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class FutureCollector<S, T>
implements FutureDone<S> {
    private final Collector<S, T> collector;
    private final ResolvableFuture<T> target;
    private final int size;
    private final Entry[] results;
    private final AtomicInteger position = new AtomicInteger();
    private final AtomicInteger countdown;

    public FutureCollector(int size, Collector<S, T> collector, ResolvableFuture<T> target) {
        this.size = size;
        this.collector = collector;
        this.target = target;
        this.results = this.entryArray(size);
        this.countdown = new AtomicInteger(size);
    }

    private Entry[] entryArray(int size) {
        Entry[] entries = new Entry[size];
        for (int i = 0; i < size; ++i) {
            entries[i] = new Entry();
        }
        return entries;
    }

    public void failed(Throwable e) throws Exception {
        this.add(this.position.getAndIncrement(), (byte)2, e);
    }

    public void resolved(S result) throws Exception {
        this.add(this.position.getAndIncrement(), (byte)1, result);
    }

    public void cancelled() throws Exception {
        this.add(this.position.getAndIncrement(), (byte)3, null);
    }

    private void add(int p, byte type, Object value) {
        Entry e = this.results[p];
        e.type = type;
        e.value = value;
        int c = this.countdown.decrementAndGet();
        if (c != 0) {
            return;
        }
        if (c < 0) {
            throw new IllegalStateException("got more than " + this.size + " results");
        }
        Results<S> r = this.readResults();
        this.done(((Results)r).results, ((Results)r).errors, ((Results)r).cancelled);
    }

    private void done(Collection<S> results, Collection<Throwable> errors, int cancelled) {
        Object result;
        if (!errors.isEmpty()) {
            this.target.fail(ThrowableUtils.buildCollectedException(errors));
            return;
        }
        if (cancelled > 0) {
            this.target.cancel();
            return;
        }
        try {
            result = this.collector.collect(results);
        }
        catch (Exception error) {
            this.target.fail((Throwable)error);
            return;
        }
        this.target.resolve(result);
    }

    private Results<S> readResults() {
        ArrayList<Object> results = new ArrayList<Object>();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        int cancelled = 0;
        block5: for (Entry e : this.results) {
            switch (e.type) {
                case 2: {
                    errors.add((Throwable)e.value);
                    continue block5;
                }
                case 1: {
                    results.add(e.value);
                    continue block5;
                }
                case 3: {
                    ++cancelled;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid entry type: " + e.type);
                }
            }
        }
        return new Results(results, errors, cancelled);
    }

    private static class Results<T> {
        private final List<T> results;
        private final List<Throwable> errors;
        private final int cancelled;

        @ConstructorProperties(value={"results", "errors", "cancelled"})
        public Results(List<T> results, List<Throwable> errors, int cancelled) {
            this.results = results;
            this.errors = errors;
            this.cancelled = cancelled;
        }
    }

    private static final class Entry {
        private static final byte RESULT = 1;
        private static final byte ERROR = 2;
        private static final byte CANCEL = 3;
        private byte type;
        private Object value;

        private Entry() {
        }
    }
}

