/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async.collector;

import eu.toolchain.async.AsyncCaller;
import eu.toolchain.async.FutureDone;
import eu.toolchain.async.ResolvableFuture;
import eu.toolchain.async.StreamCollector;
import java.util.concurrent.atomic.AtomicInteger;

public class FutureStreamCollector<S, T>
implements FutureDone<S> {
    private final AsyncCaller caller;
    private final StreamCollector<S, T> collector;
    private final ResolvableFuture<T> target;
    private final AtomicInteger countdown;
    private final AtomicInteger successful = new AtomicInteger();
    private final AtomicInteger failed = new AtomicInteger();
    private final AtomicInteger cancelled = new AtomicInteger();

    public FutureStreamCollector(AsyncCaller caller, int size, StreamCollector<S, T> collector, ResolvableFuture<T> target) {
        this.caller = caller;
        this.collector = collector;
        this.target = target;
        this.countdown = new AtomicInteger(size);
    }

    public void failed(Throwable e) throws Exception {
        this.failed.incrementAndGet();
        this.handleError(e);
        this.check();
    }

    public void resolved(S result) throws Exception {
        this.successful.incrementAndGet();
        this.handleFinish(result);
        this.check();
    }

    public void cancelled() throws Exception {
        this.cancelled.incrementAndGet();
        this.handleCancelled();
        this.check();
    }

    private void handleError(Throwable error) {
        this.caller.failStreamCollector(this.collector, error);
    }

    private void handleFinish(S result) {
        this.caller.resolveStreamCollector(this.collector, result);
    }

    private void handleCancelled() {
        this.caller.cancelStreamCollector(this.collector);
    }

    private void done() {
        Object result;
        try {
            result = this.collector.end(this.successful.get(), this.failed.get(), this.cancelled.get());
        }
        catch (Exception e) {
            this.target.fail((Throwable)e);
            return;
        }
        this.target.resolve(result);
    }

    private void check() throws Exception {
        if (this.countdown.decrementAndGet() == 0) {
            this.done();
        }
    }
}

