
package eu.toop.regrep.rim;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.wsaddr.EndpointReferenceType;


/**
 * 
 *         Contains the information needed by the server to deliver notifications for the subscription. 
 *         It includes the reference to the endpoint where notifications should be delivered.
 *       
 * 
 * <p>Java class for DeliveryInfoType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="DeliveryInfoType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}ExtensibleObjectType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="NotifyTo" type="{http://www.w3.org/2005/08/addressing}EndpointReferenceType"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="notificationOption" type="{urn:oasis:names:tc:ebxml-regrep:xsd:rim:4.0}objectReferenceType" default="urn:oasis:names:tc:ebxml-regrep:NotificationOptionType:ObjectRefs" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DeliveryInfoType", propOrder = {
    "notifyTo"
})
@CodingStyleguideUnaware
public class DeliveryInfoType
    extends ExtensibleObjectType
{

    @XmlElement(name = "NotifyTo", required = true)
    private EndpointReferenceType notifyTo;
    @XmlAttribute(name = "notificationOption")
    private String notificationOption;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public DeliveryInfoType() {
    }

    /**
     * Gets the value of the notifyTo property.
     * 
     * @return
     *     possible object is
     *     {@link EndpointReferenceType }
     *     
     */
    @Nullable
    public EndpointReferenceType getNotifyTo() {
        return notifyTo;
    }

    /**
     * Sets the value of the notifyTo property.
     * 
     * @param value
     *     allowed object is
     *     {@link EndpointReferenceType }
     *     
     */
    public void setNotifyTo(
        @Nullable
        EndpointReferenceType value) {
        this.notifyTo = value;
    }

    /**
     * Gets the value of the notificationOption property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getNotificationOption() {
        if (notificationOption == null) {
            return "urn:oasis:names:tc:ebxml-regrep:NotificationOptionType:ObjectRefs";
        } else {
            return notificationOption;
        }
    }

    /**
     * Sets the value of the notificationOption property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNotificationOption(
        @Nullable
        String value) {
        this.notificationOption = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final DeliveryInfoType rhs = ((DeliveryInfoType) o);
        if (!EqualsHelper.equals(notificationOption, rhs.notificationOption)) {
            return false;
        }
        if (!EqualsHelper.equals(notifyTo, rhs.notifyTo)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(notificationOption).append(notifyTo).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("notificationOption", notificationOption).append("notifyTo", notifyTo).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DeliveryInfoType ret) {
        super.cloneTo(ret);
        ret.notificationOption = notificationOption;
        ret.notifyTo = ((notifyTo == null)?null:notifyTo.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DeliveryInfoType clone() {
        DeliveryInfoType ret = new DeliveryInfoType();
        cloneTo(ret);
        return ret;
    }

}
