/*
 * Decompiled with CFR 0.152.
 */
package eu.trisquare.bytemapper;

import eu.trisquare.bytemapper.DataExceedsBufferException;
import eu.trisquare.bytemapper.EmptyBufferException;
import eu.trisquare.bytemapper.IllegalFieldModifierException;
import eu.trisquare.bytemapper.NegativeIndexException;
import eu.trisquare.bytemapper.ReflectionHelper;
import eu.trisquare.bytemapper.SizeTooSmallException;
import eu.trisquare.bytemapper.annotations.Value;
import eu.trisquare.bytemapper.fieldmapper.FieldMapper;
import eu.trisquare.bytemapper.fieldmapper.FieldMapperProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.List;

public class ByteMapper {
    private ByteMapper() {
    }

    public static <T> T mapValues(T instance, ByteBuffer byteBuffer) {
        Class<?> objectClass = instance.getClass();
        List<Field> annotatedFields = ReflectionHelper.getAnnotatedFields(objectClass, Value.class);
        for (Field field : annotatedFields) {
            field.setAccessible(true);
            ByteMapper.mapFieldValue(field, instance, byteBuffer);
            field.setAccessible(false);
        }
        return instance;
    }

    public static <T> T mapValues(Class<T> clazz, ByteBuffer byteBuffer) {
        T instance = ReflectionHelper.getInstance(clazz);
        return ByteMapper.mapValues(instance, byteBuffer);
    }

    private static void mapFieldValue(Field field, Object instance, ByteBuffer byteBuffer) {
        if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            throw new IllegalFieldModifierException(field);
        }
        Value valueAnnotation = field.getAnnotation(Value.class);
        Class<?> fieldType = field.getType();
        FieldMapper fieldMapper = FieldMapperProvider.getMapper(fieldType);
        int bufferLimit = byteBuffer.limit();
        ByteMapper.checkBufferLimit(bufferLimit);
        int startByte = valueAnnotation.startByte();
        ByteMapper.checkStartByte(startByte, bufferLimit);
        int size = valueAnnotation.size();
        ByteMapper.checkSize(startByte, size, bufferLimit);
        boolean isBigEndian = valueAnnotation.bigEndian();
        ByteBuffer workingBuffer = byteBuffer.duplicate().asReadOnlyBuffer();
        Object mappedValue = fieldMapper.getValue(workingBuffer, isBigEndian, startByte, size);
        ReflectionHelper.setValue(field, instance, mappedValue);
    }

    private static void checkBufferLimit(int bufferLimit) {
        if (bufferLimit < 1) {
            throw new EmptyBufferException(bufferLimit);
        }
    }

    private static void checkStartByte(int startByte, int bufferLimit) {
        if (startByte < 0) {
            throw new NegativeIndexException(startByte);
        }
    }

    private static void checkSize(int startByte, int size, int bufferLimit) {
        if (size < 1) {
            throw new SizeTooSmallException(size);
        }
        if (startByte + size > bufferLimit) {
            throw new DataExceedsBufferException(startByte, size, bufferLimit);
        }
    }
}

