/*
 * Decompiled with CFR 0.152.
 */
package eu.trisquare.bytemapper;

import eu.trisquare.bytemapper.AbstractClassInstantiationException;
import eu.trisquare.bytemapper.NoAccessibleConstructorException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    static void setValue(Field field, Object instance, Object value) {
        try {
            field.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Unable to set value for field %s. ", field.getName()), e);
        }
    }

    static List<Field> getAnnotatedFields(Class<?> objectClass, Class<? extends Annotation> annotation) {
        return Stream.of(objectClass.getDeclaredFields()).filter(field -> field.isAnnotationPresent(annotation)).collect(Collectors.toList());
    }

    static <T> Constructor<T> getConstructor(Class<T> clazz) {
        Constructor<T> constructor;
        if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isInterface()) {
            throw new AbstractClassInstantiationException(clazz);
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new NoAccessibleConstructorException(clazz);
        }
        return constructor;
    }

    static <T> T getInstance(Class<T> clazz) {
        T instance;
        Constructor<T> constructor = ReflectionHelper.getConstructor(clazz);
        try {
            constructor.setAccessible(true);
            instance = constructor.newInstance(new Object[0]);
            constructor.setAccessible(false);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Class cannot be instantiated: " + clazz.getSimpleName(), e);
        }
        return instance;
    }
}

