/*
 * Decompiled with CFR 0.152.
 */
package eu.trisquare.bytemapper.fieldmapper;

import eu.trisquare.bytemapper.fieldmapper.FieldMapperBase;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ArrayUtils;

public class ArrayFieldMapper
extends FieldMapperBase {
    private final ByteArrayMapper mapper;

    ArrayFieldMapper(ByteArrayMapper mapper, Class<?> supportedType) {
        super(0, supportedType);
        this.mapper = mapper;
    }

    private static byte[] readBytes(ByteBuffer buffer, int startByte, int size) {
        ByteBuffer src = (ByteBuffer)buffer.duplicate().position(startByte);
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = src.get();
        }
        return bytes;
    }

    @Override
    protected Object map(ByteBuffer buffer, boolean isBigEndian, int startByte, int size) {
        byte[] bytes = ArrayFieldMapper.readBytes(buffer, startByte, size);
        if (!isBigEndian) {
            ArrayUtils.reverse((byte[])bytes);
        }
        return this.mapper.map(bytes);
    }

    @Override
    protected void checkSize(int requestedSize) {
    }

    @FunctionalInterface
    static interface ByteArrayMapper {
        public Object map(byte[] var1);
    }
}

