/*
 * Decompiled with CFR 0.152.
 */
package eu.trisquare.bytemapper.fieldmapper;

import eu.trisquare.bytemapper.fieldmapper.FieldMapper;
import eu.trisquare.bytemapper.fieldmapper.TooSmallDatatypeException;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ClassUtils;

abstract class FieldMapperBase
implements FieldMapper {
    protected final int maximumSupportedSize;
    private final Class<?> returnedType;

    protected FieldMapperBase(int maxSupportedSize, Class<?> returnedType) {
        this.maximumSupportedSize = maxSupportedSize;
        this.returnedType = returnedType;
    }

    protected abstract Object map(ByteBuffer var1, boolean var2, int var3, int var4);

    @Override
    public boolean isEligible(Class<?> type) {
        return ClassUtils.isAssignable(this.returnedType, type);
    }

    @Override
    public Object getValue(ByteBuffer buffer, boolean isBigEndian, int startByte, int size) {
        this.checkSize(size);
        return this.map(buffer, isBigEndian, startByte, size);
    }

    protected void checkSize(int requestedSize) {
        if (requestedSize > this.maximumSupportedSize) {
            throw new TooSmallDatatypeException(this.returnedType, this.maximumSupportedSize, requestedSize);
        }
    }
}

