/*
 * Decompiled with CFR 0.152.
 */
package eu.trisquare.bytemapper.fieldmapper;

import java.math.BigInteger;
import java.nio.ByteBuffer;

public class FieldMapperHelper {
    private FieldMapperHelper() {
    }

    static byte toByte(ByteBuffer buffer, boolean isBigEndian, int startByte, int size) {
        return buffer.get(startByte);
    }

    static boolean toBoolean(ByteBuffer buffer, boolean isBigEndian, int startByte, int size) {
        boolean outcome = false;
        for (int i = startByte; i < startByte + size; ++i) {
            outcome |= buffer.get(i) != 0;
        }
        return outcome;
    }

    static short toShort(ByteBuffer buffer, boolean isBigEndian, int startByte, int size) {
        BigInteger value = FieldMapperHelper.toBigInteger(buffer, isBigEndian, startByte, size);
        return value.shortValueExact();
    }

    static int toInt(ByteBuffer buffer, boolean isBigEndian, int startByte, int size) {
        BigInteger value = FieldMapperHelper.toBigInteger(buffer, isBigEndian, startByte, size);
        return value.intValueExact();
    }

    static long toLong(ByteBuffer buffer, boolean isBigEndian, int startByte, int size) {
        BigInteger value = FieldMapperHelper.toBigInteger(buffer, isBigEndian, startByte, size);
        return value.longValueExact();
    }

    static Byte[] toByteObjectArray(byte[] source) {
        Byte[] destination = new Byte[source.length];
        for (int i = 0; i < source.length; ++i) {
            destination[i] = source[i];
        }
        return destination;
    }

    private static BigInteger toBigInteger(ByteBuffer buffer, boolean isBigEndian, int startByte, int size) {
        BigInteger value = BigInteger.ZERO;
        for (int i = 0; i < size; ++i) {
            int current = buffer.get(startByte + i) & 0xFF;
            int bitShift = isBigEndian ? (size - i - 1) * 8 : i * 8;
            value = BigInteger.valueOf(current).shiftLeft(bitShift).add(value);
        }
        return value;
    }
}

