/*
 * Decompiled with CFR 0.152.
 */
package eu.trisquare.bytemapper.fieldmapper;

import eu.trisquare.bytemapper.fieldmapper.ArrayFieldMapper;
import eu.trisquare.bytemapper.fieldmapper.FieldMapper;
import eu.trisquare.bytemapper.fieldmapper.FieldMapperHelper;
import eu.trisquare.bytemapper.fieldmapper.NoMapperFoundException;
import eu.trisquare.bytemapper.fieldmapper.SingleValueFieldMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FieldMapperProvider {
    private static final List<FieldMapper> mappers = new ArrayList<FieldMapper>();

    public static FieldMapper getMapper(Class<?> clazz) {
        Optional<FieldMapper> oMapper = mappers.stream().filter(mapper -> mapper.isEligible(clazz)).findFirst();
        if (!oMapper.isPresent()) {
            throw new NoMapperFoundException(clazz);
        }
        return oMapper.get();
    }

    static {
        mappers.add(new ArrayFieldMapper(String::new, String.class));
        mappers.add(new ArrayFieldMapper(bytes -> bytes, byte[].class));
        mappers.add(new ArrayFieldMapper(FieldMapperHelper::toByteObjectArray, Byte[].class));
        mappers.add(new SingleValueFieldMapper(FieldMapperHelper::toLong, 8, Long.TYPE));
        mappers.add(new SingleValueFieldMapper(FieldMapperHelper::toInt, 4, Integer.TYPE));
        mappers.add(new SingleValueFieldMapper(FieldMapperHelper::toShort, 2, Short.TYPE));
        mappers.add(new SingleValueFieldMapper(FieldMapperHelper::toByte, 1, Byte.TYPE));
        mappers.add(new SingleValueFieldMapper(FieldMapperHelper::toBoolean, 1, Boolean.TYPE));
    }
}

