/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j;

import eu.verdelhan.ta4j.Operation;
import eu.verdelhan.ta4j.OperationType;

public class Trade {
    private Operation entry;
    private Operation exit;
    private OperationType startingType;

    public Trade() {
        this(OperationType.BUY);
    }

    public Trade(OperationType startingType) {
        if (startingType == null) {
            throw new IllegalArgumentException("Starting type must not be null");
        }
        this.startingType = startingType;
    }

    public Trade(Operation entry, Operation exit) {
        this.entry = entry;
        this.exit = exit;
    }

    public Operation getEntry() {
        return this.entry;
    }

    public Operation getExit() {
        return this.exit;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Trade) {
            Trade t = (Trade)obj;
            return this.entry.equals(t.getEntry()) && this.exit.equals(t.getExit());
        }
        return false;
    }

    public int hashCode() {
        return this.entry.hashCode() * 31 + this.exit.hashCode() * 17;
    }

    public void operate(int i) {
        if (this.isNew()) {
            this.entry = new Operation(i, this.startingType);
        } else if (this.isOpened()) {
            if (i < this.entry.getIndex()) {
                throw new IllegalStateException("The index i is less than the entryOperation index");
            }
            this.exit = new Operation(i, this.startingType.complementType());
        }
    }

    public boolean isClosed() {
        return this.entry != null && this.exit != null;
    }

    public boolean isOpened() {
        return this.entry != null && this.exit == null;
    }

    public boolean isNew() {
        return this.entry == null && this.exit == null;
    }

    public String toString() {
        return "Entry: " + this.entry + " exit: " + this.exit;
    }
}

