/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis;

import eu.verdelhan.ta4j.Decimal;
import eu.verdelhan.ta4j.Indicator;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CashFlow
implements Indicator<Decimal> {
    private final TimeSeries timeSeries;
    private final List<Trade> trades;
    private List<Decimal> values;

    public CashFlow(TimeSeries timeSeries, List<Trade> trades) {
        this.timeSeries = timeSeries;
        this.trades = trades;
        this.values = new ArrayList<Decimal>();
        this.values.add(Decimal.ONE);
        this.calculate();
    }

    @Override
    public Decimal getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public TimeSeries getTimeSeries() {
        return this.timeSeries;
    }

    public int getSize() {
        return this.timeSeries.getTickCount();
    }

    private void calculate() {
        for (Trade trade : this.trades) {
            int begin = trade.getEntry().getIndex() + 1;
            if (begin > this.values.size()) {
                this.values.addAll(Collections.nCopies(begin - this.values.size(), this.values.get(this.values.size() - 1)));
            }
            int end = trade.getExit().getIndex();
            for (int i = Math.max(begin, 1); i <= end; ++i) {
                Decimal ratio = trade.getEntry().isBuy() ? this.timeSeries.getTick(i).getClosePrice().dividedBy(this.timeSeries.getTick(trade.getEntry().getIndex()).getClosePrice()) : this.timeSeries.getTick(trade.getEntry().getIndex()).getClosePrice().dividedBy(this.timeSeries.getTick(i).getClosePrice());
                this.values.add(this.values.get(trade.getEntry().getIndex()).multipliedBy(ratio));
            }
        }
        if (this.timeSeries.getEnd() - this.values.size() >= 0) {
            this.values.addAll(Collections.nCopies(this.timeSeries.getEnd() - this.values.size() + 1, this.values.get(this.values.size() - 1)));
        }
    }
}

