/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis.criteria;

import eu.verdelhan.ta4j.AnalysisCriterion;
import eu.verdelhan.ta4j.Strategy;
import eu.verdelhan.ta4j.TimeSeries;
import java.util.List;

public abstract class AbstractAnalysisCriterion
implements AnalysisCriterion {
    @Override
    public Strategy chooseBest(TimeSeries series, List<Strategy> strategies) {
        Strategy bestStrategy = strategies.get(0);
        double bestCriterionValue = this.calculate(series, series.run(bestStrategy));
        for (int i = 1; i < strategies.size(); ++i) {
            Strategy currentStrategy = strategies.get(i);
            double currentCriterionValue = this.calculate(series, series.run(currentStrategy));
            if (!this.betterThan(currentCriterionValue, bestCriterionValue)) continue;
            bestStrategy = currentStrategy;
            bestCriterionValue = currentCriterionValue;
        }
        return bestStrategy;
    }

    public String toString() {
        String[] tokens = this.getClass().getSimpleName().split("(?=\\p{Lu})", -1);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length - 1; ++i) {
            sb.append(tokens[i]).append(' ');
        }
        return sb.toString().trim();
    }
}

