/*
 * Decompiled with CFR 0.152.
 */
package eu.verdelhan.ta4j.analysis.criteria;

import eu.verdelhan.ta4j.Operation;
import eu.verdelhan.ta4j.TimeSeries;
import eu.verdelhan.ta4j.Trade;
import eu.verdelhan.ta4j.analysis.criteria.AbstractAnalysisCriterion;
import eu.verdelhan.ta4j.analysis.criteria.TotalProfitCriterion;
import java.util.List;

public class LinearTransactionCostCriterion
extends AbstractAnalysisCriterion {
    private double initialAmount;
    private double a;
    private double b;
    private TotalProfitCriterion profit;

    public LinearTransactionCostCriterion(double initialAmount, double a) {
        this(initialAmount, a, 0.0);
    }

    public LinearTransactionCostCriterion(double initialAmount, double a, double b) {
        this.initialAmount = initialAmount;
        this.a = a;
        this.b = b;
        this.profit = new TotalProfitCriterion();
    }

    @Override
    public double calculate(TimeSeries series, Trade trade) {
        return this.getTradeCost(series, trade, this.initialAmount);
    }

    @Override
    public double calculate(TimeSeries series, List<Trade> trades) {
        double totalCosts = 0.0;
        double tradedAmount = this.initialAmount;
        for (Trade trade : trades) {
            double tradeCost = this.getTradeCost(series, trade, tradedAmount);
            totalCosts += tradeCost;
            tradedAmount = (tradedAmount - tradeCost) * this.profit.calculate(series, trade);
        }
        return totalCosts;
    }

    @Override
    public boolean betterThan(double criterionValue1, double criterionValue2) {
        return criterionValue1 < criterionValue2;
    }

    private double getOperationCost(Operation operation, double tradedAmount) {
        double operationCost = 0.0;
        if (operation != null) {
            return this.a * tradedAmount + this.b;
        }
        return operationCost;
    }

    private double getTradeCost(TimeSeries series, Trade trade, double initialAmount) {
        double totalTradeCost = 0.0;
        if (trade != null && trade.getEntry() != null) {
            totalTradeCost = this.getOperationCost(trade.getEntry(), initialAmount);
            if (trade.getExit() != null) {
                double newTradedAmount = (initialAmount - totalTradeCost) * this.profit.calculate(series, trade);
                totalTradeCost += this.getOperationCost(trade.getExit(), newTradedAmount);
            }
        }
        return totalTradeCost;
    }
}

